/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableExpression;
import de.renew.formalism.function.BasicFunction;
import de.renew.formalism.function.BasicUnaryFunction;
import de.renew.formalism.function.DynamicConstructorFunction;
import de.renew.formalism.function.InstanceofFunction;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.ChannelInscription;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaCharStream;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.JavaNetParserConstants;
import de.renew.formalism.java.JavaNetParserTokenManager;
import de.renew.formalism.java.LiteralParser;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.ParsedImportDecl;
import de.renew.formalism.java.PlaceBehaviourModifier;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ManualInscription;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.CreationInscription;
import de.renew.net.inscription.DownlinkInscription;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowLookup;
import de.renew.unify.Tuple;
import de.renew.util.Types;
import de.renew.util.Value;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class JavaNetParser
implements InscriptionParser,
JavaNetParserConstants {
    public static Logger logger = Logger.getLogger(JavaNetParser.class);
    ShadowLookup lookup = null;
    ParsedDeclarationNode decl = null;
    boolean inAction = false;
    NetLoader netLoader = null;
    public boolean refactoring = false;
    public JavaNetParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[120];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    @Override
    public void setLookup(ShadowLookup lookup) {
        this.lookup = lookup;
    }

    public void setNetLoader(NetLoader netLoader) {
        this.netLoader = netLoader;
    }

    @Override
    public void setDeclarationNode(ParsedDeclarationNode decl) {
        this.decl = decl;
    }

    @Override
    public final ParsedDeclarationNode DeclarationNode() throws ParseException {
        Token t;
        this.setDeclarationNode(new ParsedDeclarationNode());
        if (this.jj_2_1(3)) {
            t = this.token;
            String ignoreMe = this.PackageDeclaration();
            logger.warn((Object)("Ignoring declaration of package " + ignoreMe));
        }
        while (this.jj_2_2(3)) {
            t = this.token;
            ParsedImportDecl importDecl = this.ImportDeclaration();
            this.decl.addImport(importDecl, t.next);
        }
        while (this.jj_2_3(3)) {
            this.VariableDeclaration();
        }
        this.jj_consume_token(0);
        return this.decl;
    }

    public final String PackageDeclaration() throws ParseException {
        this.jj_consume_token(43);
        String name = this.Name();
        this.jj_consume_token(79);
        return name;
    }

    public final ParsedImportDecl ImportDeclaration() throws ParseException {
        boolean star = false;
        this.jj_consume_token(34);
        String name = this.Name();
        if (this.jj_2_4(3)) {
            this.jj_consume_token(81);
            this.jj_consume_token(100);
            star = true;
        }
        this.jj_consume_token(79);
        return new ParsedImportDecl(name, star);
    }

    public final void VariableDeclaration() throws ParseException {
        Class<?> clazz = this.Type();
        this.VariableNamePart(clazz);
        while (this.jj_2_5(3)) {
            this.jj_consume_token(80);
            this.VariableNamePart(clazz);
        }
        this.jj_consume_token(79);
    }

    public final void VariableNamePart(Class<?> clazz) throws ParseException {
        Token t = this.jj_consume_token(70);
        while (this.jj_2_6(3)) {
            this.jj_consume_token(77);
            this.jj_consume_token(78);
            clazz = JavaHelper.increaseArrayLevel(clazz, this.token);
        }
        this.decl.addVariable(clazz, t.image, t);
    }

    @Override
    public final Collection<Object> PlaceInscription() throws ParseException {
        ArrayList<Object> inscriptions = new ArrayList<Object>();
        Object single = this.SinglePlaceInscription();
        inscriptions.add(single);
        while (this.jj_2_7(3)) {
            this.jj_consume_token(79);
            if (!this.jj_2_8(3)) continue;
            single = this.SinglePlaceInscription();
            inscriptions.add(single);
        }
        this.jj_consume_token(0);
        return inscriptions;
    }

    public final Object SinglePlaceInscription() throws ParseException {
        Token errToken = this.token;
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            Class<?> type = this.Type();
            return type;
        }
        if (this.jj_2_10(3)) {
            Class<?> type = this.PrimitiveType();
            return type;
        }
        if (this.jj_2_11(Integer.MAX_VALUE)) {
            Vector<PrimaryPart> vector = this.PrimaryExpression();
            StringBuffer name = new StringBuffer();
            boolean isName = true;
            for (int i = 0; i < vector.size(); ++i) {
                PrimaryPart part = vector.elementAt(i);
                if (part.type != 0) {
                    isName = false;
                    continue;
                }
                if (i > 0) {
                    name.append('.');
                }
                name.append((String)part.obj);
            }
            String aName = name.toString();
            if ("fifo".equals(aName)) {
                return new PlaceBehaviourModifier(1);
            }
            if ("multiset".equals(aName)) {
                return new PlaceBehaviourModifier(0);
            }
            if (isName) {
                try {
                    Object obj = this.decl.interpreteName(aName);
                    if (obj instanceof Class) {
                        return obj;
                    }
                }
                catch (LinkageError e) {
                    logger.warn((Object)("Encountered " + String.valueOf(e)), (Throwable)e);
                    throw JavaHelper.makeParseException("Class " + aName + " could not be loaded due to " + e.toString(), errToken);
                }
            }
            return JavaHelper.makeExpression(vector, null, this.decl, errToken, this.refactoring);
        }
        if (this.jj_2_12(3)) {
            TypedExpression expr = this.Expression();
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    @Override
    public final Collection<TransitionInscription> TransitionInscription(boolean create, Transition transition) throws ParseException {
        ArrayList<TransitionInscription> inscriptions = new ArrayList<TransitionInscription>();
        Collection<TransitionInscription> collection = this.SingleTransitionInscription(create, transition);
        inscriptions.addAll(collection);
        while (this.jj_2_13(3)) {
            this.jj_consume_token(79);
            if (!this.jj_2_14(3)) continue;
            collection = this.SingleTransitionInscription(create, transition);
            inscriptions.addAll(collection);
        }
        this.jj_consume_token(0);
        return inscriptions;
    }

    public final Collection<TransitionInscription> SingleTransitionInscription(boolean create, Transition transition) throws ParseException {
        Collection<TransitionInscription> result;
        if (this.jj_2_15(3)) {
            TransitionInscription inscr = this.UplinkInscription();
            result = Collections.singleton(inscr);
        } else if (this.jj_2_16(Integer.MAX_VALUE)) {
            result = this.CreationInscription(create, transition);
        } else if (this.jj_2_17(Integer.MAX_VALUE)) {
            TransitionInscription inscr = this.DownlinkInscription(transition);
            result = Collections.singleton(inscr);
        } else if (this.jj_2_18(3)) {
            TransitionInscription inscr = this.GuardInscription(transition);
            result = Collections.singleton(inscr);
        } else if (this.jj_2_19(3)) {
            TransitionInscription inscr = this.ActionInscription(transition);
            result = Collections.singleton(inscr);
        } else if (this.jj_2_20(3)) {
            TransitionInscription inscr = this.ManualInscription(transition);
            result = Collections.singleton(inscr);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final TransitionInscription UplinkInscription() throws ParseException {
        Token t;
        Token colon = this.jj_consume_token(89);
        if (this.jj_2_21(3)) {
            t = this.jj_consume_token(70);
        } else if (this.jj_2_22(3)) {
            t = this.jj_consume_token(41);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(73);
        Vector<TypedExpression> args = this.ArgumentList();
        Token end = this.jj_consume_token(74);
        UplinkInscription up = new UplinkInscription(t.image, (Expression)JavaHelper.makeGuardedTupleExpression(args));
        if (this.refactoring) {
            up.uplinkBeginLine = colon.beginLine;
            up.uplinkBeginColumn = colon.beginColumn;
            up.uplinkEndLine = end.endLine;
            up.uplinkEndColumn = end.endColumn;
            up.nameBeginLine = t.beginLine;
            up.nameBeginColumn = t.beginColumn;
            up.nameEndLine = t.endLine;
            up.nameEndColumn = t.endColumn;
        }
        return up;
    }

    public final Collection<TransitionInscription> CreationInscription(boolean create, Transition transition) throws ParseException {
        Class<?> type;
        Object loc;
        Vector<TypedExpression> args = null;
        Token errToken = this.token;
        Token varT = this.jj_consume_token(70);
        try {
            loc = this.decl.interpreteName(varT.image);
        }
        catch (LinkageError e) {
            logger.warn((Object)("Encountered " + String.valueOf(e)), (Throwable)e);
            throw JavaHelper.makeParseException("Variable name expected, but " + varT.image + " is class with linkage problem: " + e.toString(), errToken);
        }
        if (!(loc instanceof LocalVariable)) {
            throw JavaHelper.makeParseException("Variable name expected: " + varT.image, errToken);
        }
        LocalVariable local = (LocalVariable)loc;
        if (this.refactoring) {
            local.variableBeginLine = varT.beginLine;
            local.variableBeginColumn = varT.beginColumn;
            local.variableEndLine = varT.endLine;
            local.variableEndColumn = varT.endColumn;
        }
        if ((type = this.decl.findType(local)) != Types.UNTYPED && !Types.allowsWideningConversion(NetInstance.class, type)) {
            throw JavaHelper.makeParseException("Variable " + local.name + " must be assignable from de.renew.net.NetInstance.", errToken);
        }
        this.jj_consume_token(89);
        this.jj_consume_token(41);
        errToken = this.token;
        Token netT = this.jj_consume_token(70);
        if (this.jj_2_23(3)) {
            this.jj_consume_token(73);
            args = this.ArgumentList();
            this.jj_consume_token(74);
        }
        if (create) {
            Net net = this.lookup.getNet(netT.image);
            if (net == null) {
                if (this.netLoader == null) {
                    throw JavaHelper.makeParseException("Unknown net: " + netT.image, errToken);
                }
                try {
                    net = this.netLoader.loadNet(netT.image);
                }
                catch (NetNotFoundException e) {
                    Throwable ex = e.getCause();
                    if (ex != null) {
                        throw JavaHelper.makeParseException("Could not load net " + netT.image + ": " + ex.toString(), errToken);
                    }
                    throw JavaHelper.makeParseException("Unknown net: " + netT.image, errToken);
                }
            }
            CreationInscription createInscr = new CreationInscription(net, local, transition);
            if (args == null) {
                return Collections.singleton(createInscr);
            }
            DownlinkInscription channelInscr = new DownlinkInscription("new", (Expression)JavaHelper.makeGuardedTupleExpression(args), (Expression)new VariableExpression(type, local), false, transition);
            return Arrays.asList(createInscr, channelInscr);
        }
        if (this.refactoring) {
            CreationInscription createInscr = new CreationInscription(null, local, transition);
            if (args == null) {
                return Collections.singleton(createInscr);
            }
            DownlinkInscription channelInscr = new DownlinkInscription("new", (Expression)JavaHelper.makeGuardedTupleExpression(args), (Expression)new VariableExpression(type, local), false, transition);
            return Arrays.asList(createInscr, channelInscr);
        }
        return Collections.emptySet();
    }

    public final TransitionInscription DownlinkInscription(Transition transition) throws ParseException {
        Token t;
        Token errToken = this.token;
        Token begin = this.token.next;
        TypedExpression callee = this.Expression();
        this.jj_consume_token(89);
        if (callee.isTyped() && !Types.allowsWideningConversion(callee.getType(), NetInstance.class)) {
            throw JavaHelper.makeParseException("Expression of net instance type expected.", errToken);
        }
        if (this.jj_2_24(3)) {
            t = this.jj_consume_token(70);
        } else if (this.jj_2_25(3)) {
            t = this.jj_consume_token(41);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(73);
        Vector<TypedExpression> args = this.ArgumentList();
        Token end = this.jj_consume_token(74);
        DownlinkInscription d = new DownlinkInscription(t.image, (Expression)JavaHelper.makeGuardedTupleExpression(args), callee.getExpression(), false, transition);
        if (this.refactoring) {
            d.downlinkBeginLine = begin.beginLine;
            d.downlinkBeginColumn = begin.beginColumn;
            d.downlinkEndLine = end.endLine;
            d.downlinkEndColumn = end.endColumn;
            d.nameBeginLine = t.beginLine;
            d.nameBeginColumn = t.beginColumn;
            d.nameEndLine = t.endLine;
            d.nameEndColumn = t.endColumn;
        }
        return d;
    }

    public final TransitionInscription GuardInscription(Transition transition) throws ParseException {
        this.jj_consume_token(31);
        TypedExpression expr = this.Expression();
        if (expr.isTyped() && expr.getType() != Boolean.TYPE) {
            throw JavaHelper.makeParseException("Boolean expression expected.", this.token);
        }
        return new GuardInscription(expr.getExpression());
    }

    public final TransitionInscription ManualInscription(Transition transition) throws ParseException {
        this.jj_consume_token(39);
        return ManualInscription.getInstance();
    }

    public final TransitionInscription ActionInscription(Transition transition) throws ParseException {
        boolean isAction = false;
        if (this.jj_2_26(3)) {
            this.jj_consume_token(10);
            isAction = true;
        }
        this.inAction = isAction;
        TypedExpression expr = this.Expression();
        if (isAction) {
            return new ActionInscription(expr.getExpression(), transition);
        }
        return new ExpressionInscription(expr.getExpression());
    }

    @Override
    public final ChannelInscription tryParseChannelInscription() throws ParseException {
        Token t;
        boolean isUplink = true;
        if (this.jj_2_27(3)) {
            this.Expression();
            isUplink = false;
        }
        this.jj_consume_token(89);
        if (this.jj_2_28(3)) {
            t = this.jj_consume_token(70);
        } else if (this.jj_2_29(3)) {
            t = this.jj_consume_token(41);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(73);
        Vector<TypedExpression> args = this.ArgumentList();
        this.jj_consume_token(74);
        this.jj_consume_token(0);
        return new ChannelInscription(isUplink, t.image, args.size());
    }

    @Override
    public final Collection<ArcInscription> ArcInscription() throws ParseException {
        ArrayList<ArcInscription> inscriptions = new ArrayList<ArcInscription>();
        ArcInscription insc = this.SingleArcInscription();
        inscriptions.add(insc);
        while (this.jj_2_30(3)) {
            this.jj_consume_token(79);
            if (!this.jj_2_31(3)) continue;
            insc = this.SingleArcInscription();
            inscriptions.add(insc);
        }
        this.jj_consume_token(0);
        return inscriptions;
    }

    public final ArcInscription SingleArcInscription() throws ParseException {
        TypedExpression time = null;
        TypedExpression expr = this.Expression();
        if (this.jj_2_32(3)) {
            this.jj_consume_token(83);
            time = this.Expression();
        }
        return new TimedExpression(expr, time);
    }

    @Override
    public final TypedExpression VariableInscription() throws ParseException {
        Token t = this.jj_consume_token(70);
        if (this.jj_2_33(3)) {
            this.jj_consume_token(79);
        }
        this.jj_consume_token(0);
        return JavaHelper.makeSinglePartExpression(new PrimaryPart(0, t.image, t), null, this.decl, this.refactoring);
    }

    public final Class<?> ClassType() throws ParseException {
        Object obj;
        Token errToken = this.token;
        String name = this.Name();
        try {
            obj = this.decl.interpreteName(name);
        }
        catch (LinkageError e) {
            logger.warn((Object)("Encountered " + String.valueOf(e)), (Throwable)e);
            throw JavaHelper.makeParseException("Could not load class " + name + " due to " + e.toString(), errToken);
        }
        if (!(obj instanceof Class)) {
            throw JavaHelper.makeParseException("No such class: " + name + ".", errToken);
        }
        return (Class)obj;
    }

    public final Class<?> NonArrayType() throws ParseException {
        Class<?> clazz = null;
        if (this.jj_2_34(3)) {
            clazz = this.PrimitiveType();
        } else if (this.jj_2_35(3)) {
            clazz = this.ClassType();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return clazz;
    }

    public final Class<?> Type() throws ParseException {
        Class<?> clazz = this.NonArrayType();
        while (this.jj_2_36(3)) {
            this.jj_consume_token(77);
            this.jj_consume_token(78);
            clazz = JavaHelper.increaseArrayLevel(clazz, this.token);
        }
        return clazz;
    }

    public final Class<?> PrimitiveType() throws ParseException {
        Class<Comparable<Boolean>> clazz;
        if (this.jj_2_37(3)) {
            this.jj_consume_token(11);
            clazz = Boolean.TYPE;
        } else if (this.jj_2_38(3)) {
            this.jj_consume_token(16);
            clazz = Character.TYPE;
        } else if (this.jj_2_39(3)) {
            this.jj_consume_token(13);
            clazz = Byte.TYPE;
        } else if (this.jj_2_40(3)) {
            this.jj_consume_token(48);
            clazz = Short.TYPE;
        } else if (this.jj_2_41(3)) {
            this.jj_consume_token(36);
            clazz = Integer.TYPE;
        } else if (this.jj_2_42(3)) {
            this.jj_consume_token(38);
            clazz = Long.TYPE;
        } else if (this.jj_2_43(3)) {
            this.jj_consume_token(28);
            clazz = Float.TYPE;
        } else if (this.jj_2_44(3)) {
            this.jj_consume_token(22);
            clazz = Double.TYPE;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return clazz;
    }

    public final String Name() throws ParseException {
        StringBuffer s = new StringBuffer();
        Token t = this.jj_consume_token(70);
        s.append(t.image);
        while (this.jj_2_45(2)) {
            this.jj_consume_token(81);
            t = this.jj_consume_token(70);
            s.append(".");
            s.append(t.image);
        }
        return s.toString();
    }

    public final TypedExpression Expression() throws ParseException {
        if (this.jj_2_46(Integer.MAX_VALUE)) {
            TypedExpression expr = this.Assignment();
            return expr;
        }
        if (this.jj_2_47(3)) {
            TypedExpression expr = this.NonAssignmentExpression();
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression Assignment() throws ParseException {
        if (this.jj_2_48(Integer.MAX_VALUE)) {
            Vector<PrimaryPart> vector = this.PrimaryExpression();
            Token errToken = this.token;
            this.jj_consume_token(82);
            TypedExpression right = this.Expression();
            if (this.inAction) {
                return JavaHelper.makeExpression(vector, right, this.decl, errToken.next, this.refactoring);
            }
            return JavaHelper.makeEqualityAssertion(JavaHelper.makeExpression(vector, null, this.decl, errToken.next, this.refactoring), right, errToken);
        }
        if (this.jj_2_49(3)) {
            if (this.inAction) {
                throw JavaHelper.makeParseException("Invalid left hand side of assignment.", this.token);
            }
            TypedExpression left = this.NonAssignmentExpression();
            Token errToken = this.token;
            this.jj_consume_token(82);
            TypedExpression right = this.Expression();
            return JavaHelper.makeEqualityAssertion(left, right, errToken);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression NonAssignmentExpression() throws ParseException {
        TypedExpression expr = this.InclusiveOrExpression();
        return expr;
    }

    public final TypedExpression ConditionalOrExpression() throws ParseException {
        TypedExpression expr = this.ConditionalAndExpression();
        while (this.jj_2_50(3)) {
            Token t = this.token;
            this.jj_consume_token(94);
            TypedExpression right = this.ConditionalAndExpression();
            JavaHelper.ensureConvertability(Boolean.TYPE, expr, t);
            JavaHelper.ensureConvertability(Boolean.TYPE, right, t.next);
            expr = JavaHelper.makeBinary(expr, right, BasicFunction.LOR, t);
        }
        return expr;
    }

    public final TypedExpression ConditionalAndExpression() throws ParseException {
        TypedExpression expr = this.InclusiveOrExpression();
        while (this.jj_2_51(3)) {
            Token t = this.token;
            this.jj_consume_token(95);
            TypedExpression right = this.InclusiveOrExpression();
            JavaHelper.ensureConvertability(Boolean.TYPE, expr, t);
            JavaHelper.ensureConvertability(Boolean.TYPE, right, t.next);
            expr = JavaHelper.makeBinary(expr, right, BasicFunction.LAND, t);
        }
        return expr;
    }

    public final TypedExpression InclusiveOrExpression() throws ParseException {
        TypedExpression expr = this.ExclusiveOrExpression();
        while (this.jj_2_52(3)) {
            Token t = this.token;
            this.jj_consume_token(103);
            TypedExpression right = this.ExclusiveOrExpression();
            JavaHelper.ensureEnumerateability(expr, t);
            JavaHelper.ensureEnumerateability(right, t.next);
            JavaHelper.ensureBinaryMatch(expr, right, t);
            expr = JavaHelper.makeBinary(expr, right, BasicFunction.OR, t);
        }
        return expr;
    }

    public final TypedExpression ExclusiveOrExpression() throws ParseException {
        TypedExpression expr = this.AndExpression();
        while (this.jj_2_53(3)) {
            Token t = this.token;
            this.jj_consume_token(104);
            TypedExpression right = this.AndExpression();
            JavaHelper.ensureEnumerateability(expr, t);
            JavaHelper.ensureEnumerateability(right, t.next);
            JavaHelper.ensureBinaryMatch(expr, right, t);
            expr = JavaHelper.makeBinary(expr, right, BasicFunction.XOR, t);
        }
        return expr;
    }

    public final TypedExpression AndExpression() throws ParseException {
        TypedExpression expr = this.EqualityExpression();
        while (this.jj_2_54(3)) {
            Token t = this.token;
            this.jj_consume_token(102);
            TypedExpression right = this.EqualityExpression();
            JavaHelper.ensureEnumerateability(expr, t);
            JavaHelper.ensureEnumerateability(right, t.next);
            JavaHelper.ensureBinaryMatch(expr, right, t);
            expr = JavaHelper.makeBinary(expr, right, BasicFunction.AND, t);
        }
        return expr;
    }

    public final TypedExpression EqualityExpression() throws ParseException {
        TypedExpression expr = this.InstanceOfExpression();
        while (this.jj_2_55(3)) {
            BasicFunction fun;
            Token t = this.token;
            if (this.jj_2_56(3)) {
                this.jj_consume_token(90);
                fun = BasicFunction.EQUAL;
            } else if (this.jj_2_57(3)) {
                this.jj_consume_token(93);
                fun = BasicFunction.NEQUAL;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            TypedExpression right = this.InstanceOfExpression();
            JavaHelper.ensureBinaryMatch(expr, right, t);
            expr = JavaHelper.makeBooleanBinary(expr, right, fun);
        }
        return expr;
    }

    public final TypedExpression InstanceOfExpression() throws ParseException {
        Token t = this.token;
        TypedExpression expr = this.RelationalExpression();
        if (this.jj_2_58(3)) {
            this.jj_consume_token(35);
            Class<?> clazz = this.Type();
            JavaHelper.ensureConvertability(Object.class, expr, t);
            expr = new TypedExpression(Boolean.TYPE, (Expression)new CallExpression(Boolean.TYPE, expr.getExpression(), (Function)new InstanceofFunction(clazz, false, false)));
        }
        return expr;
    }

    public final TypedExpression RelationalExpression() throws ParseException {
        TypedExpression expr = this.ShiftExpression();
        while (this.jj_2_59(3)) {
            BasicFunction fun;
            Token t = this.token;
            if (this.jj_2_60(3)) {
                this.jj_consume_token(85);
                fun = BasicFunction.LESS;
            } else if (this.jj_2_61(3)) {
                this.jj_consume_token(84);
                fun = BasicFunction.GREATER;
            } else if (this.jj_2_62(3)) {
                this.jj_consume_token(91);
                fun = BasicFunction.LESSEQUAL;
            } else if (this.jj_2_63(3)) {
                this.jj_consume_token(92);
                fun = BasicFunction.GREATEREQUAL;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            TypedExpression right = this.ShiftExpression();
            JavaHelper.ensureConvertability(Double.TYPE, expr, t);
            JavaHelper.ensureConvertability(Double.TYPE, right, t.next);
            expr = JavaHelper.makeBooleanBinary(expr, right, fun);
        }
        return expr;
    }

    public final TypedExpression ShiftExpression() throws ParseException {
        TypedExpression expr = this.AdditiveExpression();
        while (this.jj_2_64(3)) {
            BasicFunction fun;
            Token t = this.token;
            if (this.jj_2_65(3)) {
                this.jj_consume_token(106);
                fun = BasicFunction.SHL;
            } else if (this.jj_2_66(3)) {
                this.jj_consume_token(107);
                fun = BasicFunction.SHR;
            } else if (this.jj_2_67(3)) {
                this.jj_consume_token(108);
                fun = BasicFunction.SSHR;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            TypedExpression right = this.AdditiveExpression();
            JavaHelper.ensureConvertability(Long.TYPE, expr, t);
            JavaHelper.ensureConvertability(Long.TYPE, right, t.next);
            expr = JavaHelper.makeTypedBinary(expr, right, fun, JavaHelper.unaryIntegralPromotion(expr.getType(), t));
        }
        return expr;
    }

    public final TypedExpression AdditiveExpression() throws ParseException {
        TypedExpression expr = this.MultiplicativeExpression();
        while (this.jj_2_68(3)) {
            TypedExpression right;
            Token t;
            if (this.jj_2_69(3)) {
                t = this.token;
                this.jj_consume_token(98);
                right = this.MultiplicativeExpression();
                if (expr.getType() == String.class || right.getType() == String.class) {
                    expr = JavaHelper.makeTypedBinary(expr, right, BasicFunction.PLUS, String.class);
                    continue;
                }
                JavaHelper.ensureConvertability(Double.TYPE, expr, t);
                JavaHelper.ensureConvertability(Double.TYPE, right, t.next);
                expr = JavaHelper.makeBinary(expr, right, BasicFunction.PLUS, t);
                continue;
            }
            if (this.jj_2_70(3)) {
                t = this.token;
                this.jj_consume_token(99);
                right = this.MultiplicativeExpression();
                JavaHelper.ensureConvertability(Double.TYPE, expr, t);
                JavaHelper.ensureConvertability(Double.TYPE, right, t.next);
                expr = JavaHelper.makeBinary(expr, right, BasicFunction.MINUS, t);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final TypedExpression MultiplicativeExpression() throws ParseException {
        TypedExpression expr = this.UnaryExpression();
        while (this.jj_2_71(3)) {
            BasicFunction fun;
            Token t = this.token;
            if (this.jj_2_72(3)) {
                this.jj_consume_token(100);
                fun = BasicFunction.TIMES;
            } else if (this.jj_2_73(3)) {
                this.jj_consume_token(101);
                fun = BasicFunction.DIVIDE;
            } else if (this.jj_2_74(3)) {
                this.jj_consume_token(105);
                fun = BasicFunction.MOD;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            TypedExpression right = this.UnaryExpression();
            JavaHelper.ensureConvertability(Double.TYPE, expr, t);
            JavaHelper.ensureConvertability(Double.TYPE, right, t.next);
            expr = JavaHelper.makeBinary(expr, right, fun, t);
        }
        return expr;
    }

    public final TypedExpression UnaryExpression() throws ParseException {
        if (this.jj_2_77(3)) {
            Token t = this.jj_consume_token(86);
            TypedExpression expr = this.UnaryExpression();
            JavaHelper.ensureConvertability(Boolean.TYPE, expr, t);
            return new TypedExpression(Boolean.TYPE, (Expression)new CallExpression(Boolean.TYPE, expr.getExpression(), (Function)BasicUnaryFunction.LNOT));
        }
        if (this.jj_2_78(3)) {
            Token t = this.jj_consume_token(87);
            TypedExpression expr = this.UnaryExpression();
            Class<?> type = JavaHelper.unaryIntegralPromotion(expr.getType(), t);
            return new TypedExpression(type, (Expression)new CallExpression(type, expr.getExpression(), (Function)BasicUnaryFunction.NOT));
        }
        if (this.jj_2_79(3)) {
            BasicUnaryFunction fun;
            Token t;
            if (this.jj_2_75(3)) {
                t = this.jj_consume_token(98);
                fun = BasicUnaryFunction.POS;
            } else if (this.jj_2_76(3)) {
                t = this.jj_consume_token(99);
                fun = BasicUnaryFunction.NEG;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            TypedExpression expr = this.UnaryExpression();
            Class<?> type = JavaHelper.unaryNumericPromotion(expr.getType(), t);
            return new TypedExpression(type, (Expression)new CallExpression(type, expr.getExpression(), (Function)fun));
        }
        if (this.jj_2_80(3)) {
            TypedExpression expr = this.SimpleUnaryExpression();
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression SimpleUnaryExpression() throws ParseException {
        if (this.jj_2_81(Integer.MAX_VALUE)) {
            TypedExpression expr = this.CastExpression();
            return expr;
        }
        if (this.jj_2_82(3)) {
            Vector<PrimaryPart> vector = this.PrimaryExpression();
            return JavaHelper.makeExpression(vector, null, this.decl, null, this.refactoring);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void CastLookahead() throws ParseException {
        if (this.jj_2_89(2)) {
            this.jj_consume_token(73);
            this.PrimitiveType();
            return;
        }
        if (this.jj_2_90(Integer.MAX_VALUE)) {
            this.jj_consume_token(73);
            this.Name();
            this.jj_consume_token(77);
            this.jj_consume_token(78);
            return;
        }
        if (!this.jj_2_91(3)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(73);
        this.Name();
        this.jj_consume_token(74);
        if (this.jj_2_83(3)) {
            this.jj_consume_token(73);
            return;
        }
        if (this.jj_2_84(3)) {
            this.jj_consume_token(70);
            return;
        }
        if (this.jj_2_85(3)) {
            this.jj_consume_token(53);
            return;
        }
        if (this.jj_2_86(3)) {
            this.jj_consume_token(50);
            return;
        }
        if (this.jj_2_87(3)) {
            this.jj_consume_token(41);
            return;
        }
        if (this.jj_2_88(3)) {
            this.Literal();
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression CastExpression() throws ParseException {
        TypedExpression expr;
        Token errToken;
        Class<?> clazz;
        if (this.jj_2_92(Integer.MAX_VALUE)) {
            this.jj_consume_token(73);
            clazz = this.PrimitiveType();
            this.jj_consume_token(74);
            errToken = this.token;
            expr = this.UnaryExpression();
        } else if (this.jj_2_93(3)) {
            this.jj_consume_token(73);
            clazz = this.Type();
            this.jj_consume_token(74);
            errToken = this.token;
            expr = this.SimpleUnaryExpression();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return JavaHelper.makeExplicitCastExpression(clazz, expr, errToken);
    }

    public final Vector<PrimaryPart> PrimaryExpression() throws ParseException {
        Vector<PrimaryPart> parts = new Vector<PrimaryPart>();
        PrimaryPart part = this.PrimaryPrefix();
        parts.addElement(part);
        while (this.jj_2_94(3)) {
            part = this.PrimarySuffix();
            parts.addElement(part);
        }
        return parts;
    }

    public final PrimaryPart PrimaryPrefix() throws ParseException {
        boolean tailed = false;
        if (this.jj_2_96(3)) {
            Token errToken = this.token;
            TypedExpression expr = this.Literal();
            return new PrimaryPart(3, expr, errToken);
        }
        if (this.jj_2_97(Integer.MAX_VALUE)) {
            Token errToken = this.token;
            Class<?> clazz = this.ClassType();
            this.jj_consume_token(81);
            this.jj_consume_token(17);
            return new PrimaryPart(3, new TypedExpression(Class.class, (Expression)new ConstantExpression(Class.class, clazz)), errToken);
        }
        if (this.jj_2_98(3)) {
            Token errToken = this.token;
            Token t = this.jj_consume_token(70);
            return new PrimaryPart(0, t.image, errToken);
        }
        if (this.jj_2_99(3)) {
            Token errToken = this.token;
            Token thisToken = this.jj_consume_token(53);
            LocalVariable thisVariable = new LocalVariable("this");
            if (this.refactoring) {
                thisVariable.variableBeginLine = thisToken.beginLine;
                thisVariable.variableBeginColumn = thisToken.beginColumn;
                thisVariable.variableEndLine = thisToken.endLine;
                thisVariable.variableEndColumn = thisToken.endColumn;
            }
            return new PrimaryPart(3, new TypedExpression(NetInstance.class, (Expression)new VariableExpression(NetInstance.class, thisVariable)), errToken);
        }
        if (this.jj_2_100(3)) {
            Token errToken = this.token;
            this.jj_consume_token(73);
            TypedExpression expr = this.Expression();
            this.jj_consume_token(74);
            return new PrimaryPart(3, expr, errToken);
        }
        if (this.jj_2_101(3)) {
            Token errToken = this.token;
            this.jj_consume_token(77);
            Vector<TypedExpression> vector = this.ArgumentList();
            this.jj_consume_token(78);
            return new PrimaryPart(3, new TypedExpression(Tuple.class, (Expression)JavaHelper.makeGuardedTupleExpression(vector)), errToken);
        }
        if (this.jj_2_102(3)) {
            Token errToken = this.token;
            this.jj_consume_token(75);
            Vector<TypedExpression> vector = this.ArgumentList();
            if (this.jj_2_95(3)) {
                this.jj_consume_token(89);
                if (vector.isEmpty()) {
                    throw JavaHelper.makeParseException("Tailed lists must not be empty.", errToken.next);
                }
                TypedExpression expr = this.Expression();
                vector.addElement(expr);
                tailed = true;
            }
            this.jj_consume_token(76);
            return new PrimaryPart(3, new TypedExpression(de.renew.unify.List.class, (Expression)JavaHelper.makeListExpression(vector, tailed)), errToken);
        }
        if (this.jj_2_103(3)) {
            Token errToken = this.token;
            TypedExpression expr = this.AllocationExpression();
            return new PrimaryPart(3, expr, errToken);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PrimaryPart PrimarySuffix() throws ParseException {
        if (this.jj_2_104(3)) {
            Token errToken = this.token;
            this.jj_consume_token(77);
            TypedExpression expr = this.Expression();
            this.jj_consume_token(78);
            return new PrimaryPart(1, expr, errToken);
        }
        if (this.jj_2_105(3)) {
            Token errToken = this.token;
            this.jj_consume_token(81);
            Token t = this.jj_consume_token(70);
            return new PrimaryPart(0, t.image, errToken);
        }
        if (this.jj_2_106(3)) {
            Token errToken = this.token;
            this.jj_consume_token(73);
            Vector<TypedExpression> vector = this.ArgumentList();
            this.jj_consume_token(74);
            return new PrimaryPart(2, vector, errToken);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression Literal() throws ParseException {
        Class<Object> type;
        Object obj;
        if (this.jj_2_107(3)) {
            Token t = this.jj_consume_token(62);
            String s = t.image.toLowerCase();
            if (LiteralParser.denotesLong(s)) {
                obj = new Value((Object)LiteralParser.parseLong(s));
                type = Long.TYPE;
            } else {
                obj = new Value((Object)LiteralParser.parseInt(s));
                type = Integer.TYPE;
            }
        } else if (this.jj_2_108(3)) {
            Token t = this.jj_consume_token(66);
            String s = t.image.toLowerCase();
            if (LiteralParser.denotesFloat(s)) {
                obj = new Value((Object)LiteralParser.parseFloat(s));
                type = Float.TYPE;
            } else {
                obj = new Value((Object)LiteralParser.parseDouble(s));
                type = Double.TYPE;
            }
        } else if (this.jj_2_109(3)) {
            Token t = this.jj_consume_token(68);
            obj = new Value((Object)Character.valueOf(LiteralParser.parseChar(t.image)));
            type = Character.TYPE;
        } else if (this.jj_2_110(3)) {
            Token t = this.jj_consume_token(69);
            obj = LiteralParser.parseString(t.image);
            type = String.class;
        } else if (this.jj_2_111(3)) {
            this.jj_consume_token(57);
            obj = new Value((Object)Boolean.TRUE);
            type = Boolean.TYPE;
        } else if (this.jj_2_112(3)) {
            this.jj_consume_token(25);
            obj = new Value((Object)Boolean.FALSE);
            type = Boolean.TYPE;
        } else if (this.jj_2_113(3)) {
            this.jj_consume_token(42);
            obj = null;
            type = null;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new TypedExpression(type, (Expression)new ConstantExpression(type, obj));
    }

    public final Vector<TypedExpression> ArgumentList() throws ParseException {
        Vector<TypedExpression> vector = new Vector<TypedExpression>();
        if (this.jj_2_115(3)) {
            TypedExpression expr = this.Expression();
            vector.addElement(expr);
            while (this.jj_2_114(3)) {
                this.jj_consume_token(80);
                expr = this.Expression();
                vector.addElement(expr);
            }
        }
        return vector;
    }

    public final TypedExpression AllocationExpression() throws ParseException {
        this.jj_consume_token(41);
        if (this.jj_2_116(Integer.MAX_VALUE)) {
            Class<?> clazz = this.PrimitiveType();
            TypedExpression expr = this.ArrayDimensions(clazz);
            return expr;
        }
        if (this.jj_2_117(Integer.MAX_VALUE)) {
            Class<?> clazz = this.NonArrayType();
            TypedExpression expr = this.ArrayDimensions(clazz);
            return expr;
        }
        if (this.jj_2_118(3)) {
            Token errToken = this.token;
            Class<?> clazz = this.NonArrayType();
            this.jj_consume_token(73);
            Vector<TypedExpression> vector = this.ArgumentList();
            this.jj_consume_token(74);
            return JavaHelper.makeConstructorExpression(clazz, vector, errToken);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypedExpression ArrayDimensions(Class<?> clazz) throws ParseException {
        Vector<TypedExpression> vector = new Vector<TypedExpression>();
        do {
            this.jj_consume_token(77);
            Token t = this.token;
            TypedExpression expr = this.Expression();
            this.jj_consume_token(78);
            JavaHelper.ensureConvertability(Integer.TYPE, expr, t);
            vector.addElement(expr);
            clazz = JavaHelper.increaseArrayLevel(clazz, this.token);
        } while (this.jj_2_119(2));
        while (this.jj_2_120(2)) {
            this.jj_consume_token(77);
            this.jj_consume_token(78);
            clazz = JavaHelper.increaseArrayLevel(clazz, this.token);
        }
        Object[] result = new Object[vector.size()];
        vector.copyInto(result);
        return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)JavaHelper.makeTupleExpression(vector), (Function)new DynamicConstructorFunction(clazz)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_95(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_95();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(94, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_96(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_96();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(95, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_97(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_97();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(96, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_98(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_98();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(97, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_99(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_99();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(98, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_100(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_100();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(99, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_101(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_101();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(100, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_102(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_102();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(101, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_103(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_103();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(102, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_104(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_104();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(103, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_105(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_105();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(104, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_106(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_106();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(105, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_107(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_107();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(106, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_108(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_108();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(107, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_109(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_109();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(108, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_110(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_110();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(109, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_111(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_111();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(110, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_112(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_112();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(111, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_113(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_113();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(112, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_114(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_114();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(113, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_115(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_115();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(114, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_116(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_116();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(115, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_117(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_117();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(116, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_118(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_118();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(117, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_119(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_119();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(118, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_120(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_120();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(119, xla);
        }
    }

    private boolean jj_3R_ImportDeclaration_379_3_25() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(79);
    }

    private boolean jj_3_25() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_54() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        return this.jj_3R_EqualityExpression_1154_3_47();
    }

    private boolean jj_3R_PackageDeclaration_369_3_24() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_AndExpression_1133_3_46() {
        Token xsp;
        if (this.jj_3R_EqualityExpression_1154_3_47()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_54());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_95() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3_3() {
        return this.jj_3R_VariableDeclaration_388_3_26();
    }

    private boolean jj_3_102() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_3R_ArgumentList_1660_3_39()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_95()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(76);
    }

    private boolean jj_3_24() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_2() {
        return this.jj_3R_ImportDeclaration_379_3_25();
    }

    private boolean jj_3_1() {
        return this.jj_3R_PackageDeclaration_369_3_24();
    }

    private boolean jj_3_53() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        return this.jj_3R_AndExpression_1133_3_46();
    }

    private boolean jj_3R_DownlinkInscription_730_3_74() {
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        if (this.jj_scan_token(89)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ExclusiveOrExpression_1113_3_45() {
        Token xsp;
        if (this.jj_3R_AndExpression_1133_3_46()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_101() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_3R_ArgumentList_1660_3_39()) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3_100() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3_52() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        return this.jj_3R_ExclusiveOrExpression_1113_3_45();
    }

    private boolean jj_3R_InclusiveOrExpression_1093_3_44() {
        Token xsp;
        if (this.jj_3R_ExclusiveOrExpression_1113_3_45()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_52());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_99() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3_97() {
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3_98() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_51() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_InclusiveOrExpression_1093_3_44();
    }

    private boolean jj_3R_ConditionalAndExpression_1075_3_43() {
        Token xsp;
        if (this.jj_3R_InclusiveOrExpression_1093_3_44()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryPrefix_1454_3_71() {
        if (this.jj_3R_ClassType_883_3_41()) {
            return true;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_PrimaryPrefix_1448_3_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryPrefix_1454_3_71()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_98()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_99()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_100()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_101()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_102()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_103()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_96() {
        return this.jj_3R_Literal_1588_3_56();
    }

    private boolean jj_3_50() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        return this.jj_3R_ConditionalAndExpression_1075_3_43();
    }

    private boolean jj_3_23() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_ArgumentList_1660_3_39()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_NonAssignmentExpression_1046_3_42() {
        return this.jj_3R_InclusiveOrExpression_1093_3_44();
    }

    private boolean jj_3_88() {
        return this.jj_3R_Literal_1588_3_56();
    }

    private boolean jj_3_94() {
        return this.jj_3R_PrimarySuffix_1561_3_58();
    }

    private boolean jj_3_49() {
        if (this.jj_3R_NonAssignmentExpression_1046_3_42()) {
            return true;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_PrimaryExpression_1408_3_32() {
        Token xsp;
        if (this.jj_3R_PrimaryPrefix_1448_3_62()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_94());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_48() {
        if (this.jj_3R_PrimaryExpression_1408_3_32()) {
            return true;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3_87() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_CreationInscription_631_3_73() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(89)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_Assignment_1013_3_77() {
        if (this.jj_3R_PrimaryExpression_1408_3_32()) {
            return true;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_Assignment_1013_3_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Assignment_1013_3_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_86() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_46() {
        if (this.jj_3R_NonAssignmentExpression_1046_3_42()) {
            return true;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3_85() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3_92() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_PrimitiveType_937_3_31()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3_22() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_47() {
        return this.jj_3R_NonAssignmentExpression_1046_3_42();
    }

    private boolean jj_3_93() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_Type_925_3_49()) {
            return true;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_3R_SimpleUnaryExpression_1339_3_54();
    }

    private boolean jj_3R_Expression_997_3_63() {
        return this.jj_3R_Assignment_1013_3_72();
    }

    private boolean jj_3R_Expression_997_3_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Expression_997_3_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_CastExpression_1375_5_78() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_PrimitiveType_937_3_31()) {
            return true;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_1304_3_53();
    }

    private boolean jj_3R_CastExpression_1374_3_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CastExpression_1375_5_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_93()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_84() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_90() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        return this.jj_scan_token(77);
    }

    private boolean jj_3_21() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_83() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3_91() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_84()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_85()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_86()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_87()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_88()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_CastLookahead_1360_3_68() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_Name_975_3_57() {
        Token xsp;
        if (this.jj_scan_token(70)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_45());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_CastLookahead_1357_3_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_CastLookahead_1360_3_68()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_91()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_UplinkInscription_591_3_35() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                return true;
            }
        }
        return this.jj_scan_token(73);
    }

    private boolean jj_3_89() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        return this.jj_3R_PrimitiveType_937_3_31();
    }

    private boolean jj_3_81() {
        return this.jj_3R_CastLookahead_1357_3_55();
    }

    private boolean jj_3_82() {
        return this.jj_3R_PrimaryExpression_1408_3_32();
    }

    private boolean jj_3_44() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_17() {
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        return this.jj_scan_token(89);
    }

    private boolean jj_3_20() {
        return this.jj_3R_ManualInscription_782_3_38();
    }

    private boolean jj_3_43() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_120() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_SimpleUnaryExpression_1339_3_67() {
        return this.jj_3R_CastExpression_1374_3_75();
    }

    private boolean jj_3R_SimpleUnaryExpression_1339_3_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleUnaryExpression_1339_3_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_82()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(70);
    }

    private boolean jj_3_19() {
        return this.jj_3R_ActionInscription_794_3_37();
    }

    private boolean jj_3_42() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3_41() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_18() {
        return this.jj_3R_GuardInscription_767_3_36();
    }

    private boolean jj_3_40() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_SingleTransitionInscription_563_5_65() {
        return this.jj_3R_DownlinkInscription_730_3_74();
    }

    private boolean jj_3_119() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3_39() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3_80() {
        return this.jj_3R_SimpleUnaryExpression_1339_3_54();
    }

    private boolean jj_3R_ArrayDimensions_1711_3_76() {
        Token xsp;
        if (this.jj_3_119()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_119());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_120());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SingleTransitionInscription_560_5_64() {
        return this.jj_3R_CreationInscription_631_3_73();
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_15() {
        return this.jj_3R_UplinkInscription_591_3_35();
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_76() {
        return this.jj_scan_token(99);
    }

    private boolean jj_3R_SingleTransitionInscription_556_3_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SingleTransitionInscription_560_5_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SingleTransitionInscription_563_5_65()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_18()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_19()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_20()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_75() {
        return this.jj_scan_token(98);
    }

    private boolean jj_3R_PrimitiveType_937_3_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_38()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_39()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_40()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_41()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_42()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_43()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_44()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_76()) {
                return true;
            }
        }
        return this.jj_3R_UnaryExpression_1304_3_53();
    }

    private boolean jj_3_117() {
        if (this.jj_3R_Name_975_3_57()) {
            return true;
        }
        return this.jj_scan_token(77);
    }

    private boolean jj_3_78() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_1304_3_53();
    }

    private boolean jj_3_36() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3_116() {
        return this.jj_3R_PrimitiveType_937_3_31();
    }

    private boolean jj_3_118() {
        if (this.jj_3R_NonArrayType_912_3_29()) {
            return true;
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_ArgumentList_1660_3_39()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_Type_925_3_49() {
        Token xsp;
        if (this.jj_3R_NonArrayType_912_3_29()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_AllocationExpression_1687_5_70() {
        if (this.jj_3R_NonArrayType_912_3_29()) {
            return true;
        }
        return this.jj_3R_ArrayDimensions_1711_3_76();
    }

    private boolean jj_3R_UnaryExpression_1304_3_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_78()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_79()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_80()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_77() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_1304_3_53();
    }

    private boolean jj_3_14() {
        return this.jj_3R_SingleTransitionInscription_556_3_34();
    }

    private boolean jj_3R_AllocationExpression_1682_5_69() {
        if (this.jj_3R_PrimitiveType_937_3_31()) {
            return true;
        }
        return this.jj_3R_ArrayDimensions_1711_3_76();
    }

    private boolean jj_3_35() {
        return this.jj_3R_ClassType_883_3_41();
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_34() {
        return this.jj_3R_PrimitiveType_937_3_31();
    }

    private boolean jj_3R_AllocationExpression_1680_3_59() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_AllocationExpression_1682_5_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_AllocationExpression_1687_5_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_118()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_NonArrayType_912_3_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_74() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3_73() {
        return this.jj_scan_token(101);
    }

    private boolean jj_3_72() {
        return this.jj_scan_token(100);
    }

    private boolean jj_3_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_73()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_74()) {
                    return true;
                }
            }
        }
        return this.jj_3R_UnaryExpression_1304_3_53();
    }

    private boolean jj_3_114() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_MultiplicativeExpression_1280_3_52() {
        Token xsp;
        if (this.jj_3R_UnaryExpression_1304_3_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_71());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_115() {
        Token xsp;
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_114());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ArgumentList_1660_3_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_115()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_ClassType_883_3_41() {
        return this.jj_3R_Name_975_3_57();
    }

    private boolean jj_3_70() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        return this.jj_3R_MultiplicativeExpression_1280_3_52();
    }

    private boolean jj_3_33() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3_113() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3_69() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        return this.jj_3R_MultiplicativeExpression_1280_3_52();
    }

    private boolean jj_3_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_112() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_null_455_31_30() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_AdditiveExpression_1246_3_51() {
        Token xsp;
        if (this.jj_3R_MultiplicativeExpression_1280_3_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_68());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_111() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3_11() {
        if (this.jj_3R_PrimaryExpression_1408_3_32()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(79)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_110() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3_9() {
        Token xsp;
        if (this.jj_3R_NonArrayType_912_3_29()) {
            return true;
        }
        if (this.jj_3R_null_455_31_30()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_null_455_31_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_32() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3_109() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_SinglePlaceInscription_462_5_61() {
        return this.jj_3R_PrimaryExpression_1408_3_32();
    }

    private boolean jj_3_67() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3_66() {
        return this.jj_scan_token(107);
    }

    private boolean jj_3R_SingleArcInscription_845_3_40() {
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_65() {
        return this.jj_scan_token(106);
    }

    private boolean jj_3_10() {
        return this.jj_3R_PrimitiveType_937_3_31();
    }

    private boolean jj_3_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_66()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_67()) {
                    return true;
                }
            }
        }
        return this.jj_3R_AdditiveExpression_1246_3_51();
    }

    private boolean jj_3R_SinglePlaceInscription_455_5_60() {
        return this.jj_3R_Type_925_3_49();
    }

    private boolean jj_3R_ShiftExpression_1221_3_50() {
        Token xsp;
        if (this.jj_3R_AdditiveExpression_1246_3_51()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_64());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_29() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_108() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_SinglePlaceInscription_453_3_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SinglePlaceInscription_455_5_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SinglePlaceInscription_462_5_61()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_12()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_31() {
        return this.jj_3R_SingleArcInscription_845_3_40();
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_107() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3_63() {
        return this.jj_scan_token(92);
    }

    private boolean jj_3R_Literal_1588_3_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_107()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_108()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_109()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_110()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_111()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_112()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_113()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_62() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3_61() {
        return this.jj_scan_token(84);
    }

    private boolean jj_3_28() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_60() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_61()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_62()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_63()) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_ShiftExpression_1221_3_50();
    }

    private boolean jj_3_27() {
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_RelationalExpression_1196_3_66() {
        Token xsp;
        if (this.jj_3R_ShiftExpression_1221_3_50()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_59());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_3R_SinglePlaceInscription_453_3_28();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_106() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_ArgumentList_1660_3_39()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3_105() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(70);
    }

    private boolean jj_3_26() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_58() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_Type_925_3_49();
    }

    private boolean jj_3R_PrimarySuffix_1561_3_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_105()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_106()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_104() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_3R_Expression_997_3_33()) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_ActionInscription_794_3_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_26()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3R_InstanceOfExpression_1175_3_48() {
        if (this.jj_3R_RelationalExpression_1196_3_66()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_58()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_ManualInscription_782_3_38() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_VariableNamePart_398_3_27() {
        Token xsp;
        if (this.jj_scan_token(70)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_6());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_57() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3_56() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_3R_VariableNamePart_398_3_27();
    }

    private boolean jj_3_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_57()) {
                return true;
            }
        }
        return this.jj_3R_InstanceOfExpression_1175_3_48();
    }

    private boolean jj_3R_EqualityExpression_1154_3_47() {
        Token xsp;
        if (this.jj_3R_InstanceOfExpression_1175_3_48()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_55());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_VariableDeclaration_388_3_26() {
        Token xsp;
        if (this.jj_3R_Type_925_3_49()) {
            return true;
        }
        if (this.jj_3R_VariableNamePart_398_3_27()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_GuardInscription_767_3_36() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_Expression_997_3_33();
    }

    private boolean jj_3_103() {
        return this.jj_3R_AllocationExpression_1680_3_59();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[0];
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[0];
    }

    public JavaNetParser(InputStream stream) {
        this(stream, null);
    }

    public JavaNetParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JavaNetParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JavaNetParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JavaNetParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new JavaNetParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JavaNetParser(JavaNetParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JavaNetParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[121];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 121; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 120; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                        case 77: {
                            this.jj_3_78();
                            break;
                        }
                        case 78: {
                            this.jj_3_79();
                            break;
                        }
                        case 79: {
                            this.jj_3_80();
                            break;
                        }
                        case 80: {
                            this.jj_3_81();
                            break;
                        }
                        case 81: {
                            this.jj_3_82();
                            break;
                        }
                        case 82: {
                            this.jj_3_83();
                            break;
                        }
                        case 83: {
                            this.jj_3_84();
                            break;
                        }
                        case 84: {
                            this.jj_3_85();
                            break;
                        }
                        case 85: {
                            this.jj_3_86();
                            break;
                        }
                        case 86: {
                            this.jj_3_87();
                            break;
                        }
                        case 87: {
                            this.jj_3_88();
                            break;
                        }
                        case 88: {
                            this.jj_3_89();
                            break;
                        }
                        case 89: {
                            this.jj_3_90();
                            break;
                        }
                        case 90: {
                            this.jj_3_91();
                            break;
                        }
                        case 91: {
                            this.jj_3_92();
                            break;
                        }
                        case 92: {
                            this.jj_3_93();
                            break;
                        }
                        case 93: {
                            this.jj_3_94();
                            break;
                        }
                        case 94: {
                            this.jj_3_95();
                            break;
                        }
                        case 95: {
                            this.jj_3_96();
                            break;
                        }
                        case 96: {
                            this.jj_3_97();
                            break;
                        }
                        case 97: {
                            this.jj_3_98();
                            break;
                        }
                        case 98: {
                            this.jj_3_99();
                            break;
                        }
                        case 99: {
                            this.jj_3_100();
                            break;
                        }
                        case 100: {
                            this.jj_3_101();
                            break;
                        }
                        case 101: {
                            this.jj_3_102();
                            break;
                        }
                        case 102: {
                            this.jj_3_103();
                            break;
                        }
                        case 103: {
                            this.jj_3_104();
                            break;
                        }
                        case 104: {
                            this.jj_3_105();
                            break;
                        }
                        case 105: {
                            this.jj_3_106();
                            break;
                        }
                        case 106: {
                            this.jj_3_107();
                            break;
                        }
                        case 107: {
                            this.jj_3_108();
                            break;
                        }
                        case 108: {
                            this.jj_3_109();
                            break;
                        }
                        case 109: {
                            this.jj_3_110();
                            break;
                        }
                        case 110: {
                            this.jj_3_111();
                            break;
                        }
                        case 111: {
                            this.jj_3_112();
                            break;
                        }
                        case 112: {
                            this.jj_3_113();
                            break;
                        }
                        case 113: {
                            this.jj_3_114();
                            break;
                        }
                        case 114: {
                            this.jj_3_115();
                            break;
                        }
                        case 115: {
                            this.jj_3_116();
                            break;
                        }
                        case 116: {
                            this.jj_3_117();
                            break;
                        }
                        case 117: {
                            this.jj_3_118();
                            break;
                        }
                        case 118: {
                            this.jj_3_119();
                            break;
                        }
                        case 119: {
                            this.jj_3_120();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        JavaNetParser.jj_la1_init_0();
        JavaNetParser.jj_la1_init_1();
        JavaNetParser.jj_la1_init_2();
        JavaNetParser.jj_la1_init_3();
        jj_ls = new LookaheadSuccess();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

