/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.LocalVariable;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedImportDecl;
import de.renew.formalism.java.Token;
import de.renew.util.ClassSource;
import de.renew.util.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedDeclarationNode {
    private List<String> imports = new ArrayList<String>();
    private Map<String, String> wellKnownClassesNames;
    private Map<String, Class<?>> wellKnownClasses = new HashMap();
    private Map<String, Class<?>> variables;
    private boolean anyVariablesDeclared = false;
    private Map<String, List<Integer>> variablePositions;

    public ParsedDeclarationNode() {
        this.wellKnownClassesNames = new HashMap<String, String>();
        this.variables = new HashMap();
        this.variablePositions = new HashMap<String, List<Integer>>();
    }

    public void addImport(ParsedImportDecl decl, Token token) throws ParseException {
        if (decl._star) {
            this.imports.add(decl._name);
        } else {
            Class<?> clazz;
            int pos = decl._name.lastIndexOf(".");
            String name = decl._name.substring(pos + 1);
            try {
                Object interpretation = this.interpreteWellKnownName(name);
                if (interpretation != null) {
                    throw JavaHelper.makeParseException("Class " + name + " imported twice.", token);
                }
            }
            catch (LinkageError e) {
                throw JavaHelper.makeParseException("Class " + name + " imported twice.\nAdditionally, first import cannot be loaded due to " + e.toString(), token);
            }
            try {
                clazz = ParsedDeclarationNode.classForName(decl._name);
            }
            catch (RuntimeException e) {
                throw JavaHelper.makeParseException("Could not import class " + decl._name + ".", token);
            }
            this.wellKnownClasses.put(name, clazz);
            this.wellKnownClassesNames.put(name, decl._name);
        }
    }

    public void addVariable(Class<?> clazz, String name, Token token) throws ParseException {
        try {
            Object interpretation = this.interpreteWellKnownName(name);
            if (interpretation != null) {
                if (interpretation instanceof LocalVariable) {
                    throw JavaHelper.makeParseException("Variable " + name + " declared twice.", token);
                }
                if (interpretation instanceof Class) {
                    throw JavaHelper.makeParseException("Variable " + name + " is named identically to an imported class.", token);
                }
                throw JavaHelper.makeParseException("Variable " + name + " is named identically to a " + interpretation.getClass().getName() + ".", token);
            }
        }
        catch (LinkageError e) {
            throw JavaHelper.makeParseException("Variable " + name + " is named identically to an imported class.\nAdditionally, the class cannot be loaded due to" + e.toString(), token);
        }
        this.variables.put(name, clazz);
        List<Integer> position = Arrays.asList(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        this.variablePositions.put(name, position);
        if (!"this".equals(name)) {
            this.anyVariablesDeclared = true;
        }
    }

    private static boolean classExists(String name) throws LinkageError {
        try {
            ClassSource.classForName((String)name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Class<?> classForName(String name) throws LinkageError {
        try {
            return ClassSource.classForName((String)name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class: " + name, e);
        }
    }

    public Object interpreteWellKnownName(String name) throws LinkageError {
        String iName;
        if (this.variables.containsKey(name)) {
            return new LocalVariable(name);
        }
        if (this.wellKnownClassesNames.containsKey(name) && ParsedDeclarationNode.classExists(iName = this.wellKnownClassesNames.get(name))) {
            return ParsedDeclarationNode.classForName(iName);
        }
        return null;
    }

    public Object interpreteName(String name) throws LinkageError {
        if (name.indexOf(".") >= 0) {
            if (ParsedDeclarationNode.classExists(name)) {
                return ParsedDeclarationNode.classForName(name);
            }
            return null;
        }
        Object interpretation = this.interpreteWellKnownName(name);
        if (interpretation != null) {
            return interpretation;
        }
        for (String pckg : this.imports) {
            if (!ParsedDeclarationNode.classExists(pckg + "." + name)) continue;
            return ParsedDeclarationNode.classForName(pckg + "." + name);
        }
        if (ParsedDeclarationNode.classExists(name)) {
            return ParsedDeclarationNode.classForName(name);
        }
        if (ParsedDeclarationNode.classExists("java.lang." + name)) {
            return ParsedDeclarationNode.classForName("java.lang." + name);
        }
        if (!this.anyVariablesDeclared) {
            return new LocalVariable(name);
        }
        return null;
    }

    public Class<?> findType(LocalVariable var) {
        if (this.variables.containsKey(var.name)) {
            return this.variables.get(var.name);
        }
        return Types.UNTYPED;
    }

    public String toString() {
        int sbSize = 1000;
        String variableSeparator = ", ";
        StringBuffer sb = new StringBuffer(1000);
        sb.append(this.getClass().getName());
        sb.append("(");
        sb.append("imports=").append(this.imports);
        sb.append(", ");
        sb.append("wellKnownClasses=").append(this.wellKnownClassesNames);
        sb.append(", ");
        sb.append("variables=").append(this.variables);
        sb.append(", ");
        sb.append("anyVariablesDeclared=").append(this.anyVariablesDeclared);
        this.augmentToString(sb, ", ");
        sb.append(")");
        return sb.toString();
    }

    protected void augmentToString(StringBuffer buffer, String separator) {
    }

    public Map<String, Class<?>> getWellKnownClasses() {
        return this.wellKnownClasses;
    }

    public Map<String, Class<?>> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Map<String, List<Integer>> getVariablePositions() {
        return Collections.unmodifiableMap(this.variablePositions);
    }
}

