/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.logging.CliColor;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorConfigurator;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.RepositoryTreeCellRenderer;
import de.renew.navigator.vc.VersionControlAggregator;
import de.renew.navigator.vc.impl.VersionControlAggregatorImpl;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.DIPlugin;
import java.io.File;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

public final class NavigatorVCPlugin
extends DIPlugin
implements NavigatorExtension {
    private final VersionControlAggregator _aggregator;
    private final NavigatorGui _gui;
    private final RepositoryTreeCellRenderer _renderer;

    @Inject
    public NavigatorVCPlugin(NavigatorGui gui, NavigatorFileTree model) {
        this._gui = gui;
        this._aggregator = new VersionControlAggregatorImpl();
        HashSet<Repository> repositories = new HashSet<Repository>();
        this._renderer = new RepositoryTreeCellRenderer(repositories);
        model.addObserver((o, arg) -> {
            for (TreeElement root : model.getTreeRoots()) {
                Repository repository = this._aggregator.findRepository(root.getFile());
                if (null == repository) continue;
                repositories.add(repository);
            }
            if (arg instanceof FilesystemController) {
                repositories.forEach(Repository::update);
            }
        });
        gui.addExtension((NavigatorExtension)this);
    }

    public boolean cleanup() {
        return this._gui.removeExtension((NavigatorExtension)this);
    }

    @Provides
    public VersionControlAggregator getVersionControlAggregator() {
        return this._aggregator;
    }

    public void configure(NavigatorConfigurator config) {
        config.addFileTreeCellRenderer((FileTreeCellRenderer)this._renderer);
    }

    public JMenuItem getMenuItem(JTree tree, int x, int y, Object lastPathComponent, MutableTreeNode mtn) {
        if (!(mtn instanceof FileTreeNode)) {
            return null;
        }
        File file = ((FileTreeNode)mtn).getFile();
        if (file.isDirectory()) {
            return null;
        }
        Repository repository = this._aggregator.findRepository(file);
        if (null == repository) {
            return null;
        }
        return this.buildVersionControlMenu(file, repository);
    }

    private JMenuItem buildVersionControlMenu(File file, Repository repository) {
        JMenu menu = new JMenu(repository.getVersionControl().getName());
        JMenuItem diffItem = new JMenuItem("Diff with HEAD/BASE");
        diffItem.addActionListener(e -> this._aggregator.diff(file));
        menu.add(diffItem);
        JMenuItem logItem = new JMenuItem("Log");
        logItem.addActionListener(e -> this._aggregator.log(file));
        menu.add(logItem);
        JMenuItem infoItem = new JMenuItem("Info");
        infoItem.addActionListener(e -> System.out.println(this.buildRepositoryInfo(repository)));
        menu.add(infoItem);
        return menu;
    }

    public String buildRepositoryInfo(Repository repository) {
        return this.colorStringBold(repository.getVersionControl().getName()) + this.colorStringYellow("Root Directory: ", repository.getRootDirectory().getAbsolutePath()) + this.colorStringYellow("Remote URL:     ", repository.getRemoteURL()) + this.colorStringYellow("Branch:         ", repository.getBranch()) + this.colorStringYellow("Revision:       ", repository.getLastCommit().getRevision()) + this.colorStringYellow("Author:         ", repository.getLastCommit().getAuthor()) + this.colorStringYellow("Message:        ", Commit.formatMessage(repository.getLastCommit().getMessage()));
    }

    private String colorStringBold(String stringToBeColored) {
        return CliColor.color((String)stringToBeColored, (CliColor[])new CliColor[]{CliColor.BOLD}) + "\n";
    }

    private String colorStringYellow(String stringToBeColored, String string2) {
        return CliColor.color((String)stringToBeColored, (CliColor[])new CliColor[]{CliColor.YELLOW}) + string2 + "\n";
    }
}

