/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.intern.CDockable;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class CancelDragAndDropOperation
implements CKeyboardListener {
    private CControl control;

    public CancelDragAndDropOperation(CControl control) {
        this.control = control;
    }

    public DockElement getTreeLocation() {
        return null;
    }

    private boolean dragAndDropHappening() {
        return this.control.getController().getRelocator().isOnMove();
    }

    private boolean isCancelKeyStroke(KeyEvent event) {
        KeyStroke keyStroke = this.control.getProperty(CControl.KEY_CANCEL_OPERATION);
        if (keyStroke == null) {
            return false;
        }
        KeyStroke observedKeyStroke = KeyStroke.getKeyStrokeForEvent(event);
        return keyStroke.equals(observedKeyStroke);
    }

    private void cancelOperation() {
        this.control.getController().getRelocator().cancel();
    }

    public boolean keyPressed(CDockable source, KeyEvent event) {
        if (event.isConsumed()) {
            return false;
        }
        if (this.dragAndDropHappening() && this.isCancelKeyStroke(event)) {
            this.cancelOperation();
            return true;
        }
        return false;
    }

    public boolean keyReleased(CDockable source, KeyEvent event) {
        return false;
    }

    public boolean keyTyped(CDockable source, KeyEvent event) {
        return false;
    }
}

