/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import java.util.ArrayList;
import java.util.Collection;

public class FoldingTransformer<V, E> {
    public static <V, E> Graph<V, E> foldKPartiteGraph(KPartiteGraph<V, E> g2, Predicate<V> p, Supplier<Graph<V, E>> graph_factory, Supplier<E> edge_factory) {
        Graph<V, E> newGraph = graph_factory.get();
        Collection<V> vertices = g2.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s2 : g2.getSuccessors(v)) {
                for (V t : g2.getSuccessors(s2)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    newGraph.addEdge(edge_factory.get(), v, t);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<V>> foldKPartiteGraph(KPartiteGraph<V, E> g2, Predicate<V> p, Supplier<Graph<V, Collection<V>>> graph_factory) {
        Graph<V, Collection<V>> newGraph = graph_factory.get();
        Collection<V> vertices = g2.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s2 : g2.getSuccessors(v)) {
                for (V t : g2.getSuccessors(s2)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    ArrayList<V> v_coll = (ArrayList<V>)newGraph.findEdge(v, t);
                    if (v_coll == null) {
                        v_coll = new ArrayList<V>();
                        newGraph.addEdge(v_coll, v, t);
                    }
                    v_coll.add(s2);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<E>> foldHypergraphEdges(Hypergraph<V, E> h2, Supplier<Graph<V, Collection<E>>> graph_factory) {
        Graph<V, Collection<E>> target = graph_factory.get();
        for (V v : h2.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h2.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h2.getIncidentVertices(e));
            FoldingTransformer.populateTarget(target, e, incident);
        }
        return target;
    }

    public static <V, E> Graph<V, E> foldHypergraphEdges(Hypergraph<V, E> h2, Supplier<Graph<V, E>> graph_factory, Supplier<E> edge_factory) {
        Graph<V, E> target = graph_factory.get();
        for (V v : h2.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h2.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h2.getIncidentVertices(e));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.get(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public static <V, E, F> Graph<E, F> foldHypergraphVertices(Hypergraph<V, E> h2, Supplier<Graph<E, F>> graph_factory, Supplier<F> edge_factory) {
        Graph<F, F> target = graph_factory.get();
        for (E e : h2.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h2.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h2.getIncidentEdges(v));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.get(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public Graph<E, Collection<V>> foldHypergraphVertices(Hypergraph<V, E> h2, Supplier<Graph<E, Collection<V>>> graph_factory) {
        Graph<E, Collection<E>> target = graph_factory.get();
        for (E e : h2.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h2.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h2.getIncidentEdges(v));
            FoldingTransformer.populateTarget(target, v, incident);
        }
        return target;
    }

    private static <S, T> void populateTarget(Graph<S, Collection<T>> target, T e, ArrayList<S> incident) {
        for (int i = 0; i < incident.size(); ++i) {
            S v1 = incident.get(i);
            for (int j = i + 1; j < incident.size(); ++j) {
                S v2 = incident.get(j);
                ArrayList<T> e_coll = (ArrayList<T>)target.findEdge(v1, v2);
                if (e_coll == null) {
                    e_coll = new ArrayList<T>();
                    target.addEdge(e_coll, v1, v2);
                }
                e_coll.add(e);
            }
        }
    }
}

