/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractIncrementalDFABuilder<I>
implements IncrementalDFABuilder<I>,
InputAlphabetHolder<I>,
Serializable {
    protected final Alphabet<I> inputAlphabet;
    protected int alphabetSize;

    public AbstractIncrementalDFABuilder(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        return this.lookup(word) != Acceptance.DONT_KNOW;
    }

    @Override
    public void insert(Word<? extends I> word) {
        this.insert(word, true);
    }

    protected static abstract class AbstractTransitionSystemView<S, I, T>
    implements IncrementalDFABuilder.TransitionSystemView<S, I, T> {
        protected AbstractTransitionSystemView() {
        }

        @Override
        public Acceptance getStateProperty(S state) {
            return this.getAcceptance(state);
        }

        @Override
        public Void getTransitionProperty(T transition) {
            return null;
        }
    }

    protected static abstract class AbstractGraphView<I, N, E>
    implements IncrementalDFABuilder.GraphView<I, N, E> {
        protected AbstractGraphView() {
        }

        @Override
        public VisualizationHelper<N, E> getVisualizationHelper() {
            return new DefaultVisualizationHelper<N, E>(){

                @Override
                public Collection<N> initialNodes() {
                    return Collections.singleton(this.getInitialNode());
                }

                @Override
                public boolean getNodeProperties(N node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    switch (this.getAcceptance(node)) {
                        case TRUE: {
                            properties.put("shape", "doublecircle");
                            break;
                        }
                        case DONT_KNOW: {
                            properties.put("style", "dashed");
                            break;
                        }
                    }
                    return true;
                }

                @Override
                public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    Object input = this.getInputSymbol(edge);
                    properties.put("label", String.valueOf(input));
                    return true;
                }
            };
        }
    }
}

