/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import java.io.Serializable;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.incremental.dfa.Acceptance;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Node<I>
implements Serializable {
    private Acceptance acceptance;
    private @Nullable ResizingArrayStorage<Node<I>> children;

    public Node() {
        this(Acceptance.DONT_KNOW);
    }

    public Node(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    public Acceptance getAcceptance() {
        return this.acceptance;
    }

    public void setAcceptance(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    public @Nullable Node<I> getChild(int idx) {
        if (this.children == null) {
            return null;
        }
        return ((Node[])this.children.array)[idx];
    }

    public void setChild(int idx, int alphabetSize, Node<I> child) {
        if (this.children == null) {
            this.children = new ResizingArrayStorage<Node>(Node.class, alphabetSize);
        }
        ((Node[])this.children.array)[idx] = child;
    }

    public void makeSink() {
        this.children = null;
        this.acceptance = Acceptance.FALSE;
    }

    boolean ensureInputCapacity(int capacity) {
        if (this.children == null) {
            return false;
        }
        return this.children.ensureCapacity(capacity);
    }
}

