/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.Pair;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelDeserializer;
import net.automatalib.serialization.dot.Edge;
import net.automatalib.serialization.dot.InternalDOTParser;
import net.automatalib.serialization.dot.Node;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class DOTMutableAutomatonParser<I, SP, TP, A extends MutableAutomaton<?, I, ?, SP, TP>>
implements InputModelDeserializer<I, A> {
    private final AutomatonCreator<A, I> creator;
    private final Function<Map<String, String>, SP> nodeParser;
    private final Function<Map<String, String>, Pair<I, TP>> edgeParser;
    private final Collection<String> initialNodeIds;
    private final boolean fakeInitialNodeIds;

    public DOTMutableAutomatonParser(AutomatonCreator<A, I> creator, Function<Map<String, String>, SP> nodeParser, Function<Map<String, String>, Pair<I, TP>> edgeParser, Collection<String> initialNodeIds, boolean fakeInitialNodeIds) {
        this.creator = creator;
        this.nodeParser = nodeParser;
        this.edgeParser = edgeParser;
        this.initialNodeIds = initialNodeIds;
        this.fakeInitialNodeIds = fakeInitialNodeIds;
    }

    @Override
    public InputModelData<I, A> readModel(InputStream is) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(is);){
            InternalDOTParser parser = new InternalDOTParser(r);
            parser.parse();
            assert (parser.isDirected());
            HashSet<I> inputs = new HashSet<I>();
            for (Edge edge : parser.getEdges()) {
                if (this.fakeInitialNodeIds && this.initialNodeIds.contains(edge.src)) continue;
                inputs.add(this.edgeParser.apply(edge.attributes).getFirst());
            }
            Alphabet alphabet = Alphabets.fromCollection(inputs);
            MutableAutomaton automaton = (MutableAutomaton)this.creator.createAutomaton(alphabet, parser.getNodes().size());
            this.parseNodesAndEdges(parser, automaton);
            InputModelData inputModelData = new InputModelData(automaton, alphabet);
            return inputModelData;
        }
    }

    private <S> void parseNodesAndEdges(InternalDOTParser parser, MutableAutomaton<S, I, ?, SP, TP> automaton) {
        HashMap<String, S> stateMap = Maps.newHashMapWithExpectedSize(parser.getNodes().size());
        for (Node node : parser.getNodes()) {
            if (this.fakeInitialNodeIds && this.initialNodeIds.contains(node.id)) continue;
            S state = !this.fakeInitialNodeIds && this.initialNodeIds.contains(node.id) ? automaton.addInitialState(this.nodeParser.apply(node.attributes)) : automaton.addState(this.nodeParser.apply(node.attributes));
            stateMap.put(node.id, state);
        }
        for (Edge edge : parser.getEdges()) {
            if (this.fakeInitialNodeIds && this.initialNodeIds.contains(edge.src)) {
                automaton.setInitial(stateMap.get(edge.tgt), true);
                continue;
            }
            Pair<I, TP> property = this.edgeParser.apply(edge.attributes);
            automaton.addTransition(stateMap.get(edge.src), property.getFirst(), stateMap.get(edge.tgt), property.getSecond());
        }
    }
}

