/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.apsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.EdgeWeights;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.util.graphs.apsp.APSPResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FloydWarshallAPSP<N, E>
implements APSPResult<N, E> {
    private final int size;
    private final NodeIDs<N> ids;
    private final @Nullable APSPRecord<E>[][] table;

    public FloydWarshallAPSP(Graph<N, E> graph, EdgeWeights<E> ew) {
        this.size = graph.size();
        this.ids = graph.nodeIDs();
        this.table = new APSPRecord[this.size][this.size];
        this.initialize(graph, ew);
    }

    private void initialize(Graph<N, E> graph, EdgeWeights<E> ew) {
        for (int i = 0; i < this.size; ++i) {
            N src = this.ids.getNode(i);
            Collection edges = graph.getOutgoingEdges(src);
            for (Object edge : edges) {
                Object tgt = graph.getTarget(edge);
                if (Objects.equals(tgt, src)) continue;
                int j = this.ids.getNodeId(tgt);
                float w = ew.getEdgeWeight(edge);
                APSPRecord<E> prev = this.table[i][j];
                if (prev != null && !(prev.distance > w)) continue;
                this.table[i][j] = new APSPRecord(edge, w);
            }
        }
    }

    public static <N, E> APSPResult<N, E> findAPSP(Graph<N, E> graph, EdgeWeights<E> edgeWeights) {
        FloydWarshallAPSP<N, E> fw = new FloydWarshallAPSP<N, E>(graph, edgeWeights);
        fw.findAPSP();
        return fw;
    }

    public void findAPSP() {
        for (int k = 0; k < this.size; ++k) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    if (j == i) continue;
                    APSPRecord<E> currRec = this.table[i][j];
                    if (k == i || k == j) continue;
                    APSPRecord<E> part1 = this.table[i][k];
                    APSPRecord<E> part2 = this.table[k][j];
                    if (part1 == null || part2 == null) continue;
                    float dist1 = part1.distance;
                    float dist2 = part2.distance;
                    float total = dist1 + dist2;
                    if (currRec == null) {
                        this.table[i][j] = currRec = new APSPRecord(total, k, part1.numEdges + part2.numEdges);
                        continue;
                    }
                    if (!(currRec.distance > total)) continue;
                    currRec.distance = total;
                    currRec.middle = k;
                    currRec.numEdges = part1.numEdges + part2.numEdges;
                }
            }
        }
    }

    @Override
    public float getShortestPathDistance(N src, N tgt) {
        int tgtId;
        int srcId = this.ids.getNodeId(src);
        APSPRecord<E> rec = this.table[srcId][tgtId = this.ids.getNodeId(tgt)];
        if (rec == null) {
            return Float.NEGATIVE_INFINITY;
        }
        return rec.distance;
    }

    @Override
    public @Nullable List<E> getShortestPath(N src, N tgt) {
        int tgtId;
        int srcId = this.ids.getNodeId(src);
        APSPRecord<E> rec = this.table[srcId][tgtId = this.ids.getNodeId(tgt)];
        if (rec == null) {
            return null;
        }
        ArrayList result = new ArrayList(rec.numEdges);
        this.buildPath(result, srcId, tgtId, rec);
        return result;
    }

    private void buildPath(List<E> path, int srcId, int tgtId, APSPRecord<E> rec) {
        if (rec.middle == -1) {
            path.add(rec.edge);
            return;
        }
        int middle = rec.middle;
        this.buildPath(path, srcId, middle, this.table[srcId][middle]);
        this.buildPath(path, middle, tgtId, this.table[middle][tgtId]);
    }

    private static final class APSPRecord<E> {
        public final @Nullable E edge;
        public float distance;
        public int middle;
        public int numEdges;

        APSPRecord(E edge, float distance) {
            this.edge = edge;
            this.distance = distance;
            this.middle = -1;
            this.numEdges = 1;
        }

        APSPRecord(float distance, int middle, int numEdges) {
            this.edge = null;
            this.distance = distance;
            this.middle = middle;
            this.numEdges = numEdges;
        }
    }
}

