/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.security.DefaultTooltipStrategy;
import bibliothek.gui.dock.security.TooltipStrategy;
import bibliothek.gui.dock.security.TooltipStrategyCallback;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Workarounds;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class GlassedPane
extends JPanel {
    public static final PropertyKey<TooltipStrategy> TOOLTIP_STRATEGY = new PropertyKey<DefaultTooltipStrategy>("tooltip strategy", new ConstantPropertyFactory<DefaultTooltipStrategy>(new DefaultTooltipStrategy()), true);
    private JComponent contentPane = new JPanel();
    private JComponent glassPane = new GlassPane();
    private DockController controller;
    private boolean onSending = false;
    private PropertyValue<TooltipStrategy> tooltips = new PropertyValue<TooltipStrategy>(TOOLTIP_STRATEGY){

        @Override
        protected void valueChanged(TooltipStrategy oldValue, TooltipStrategy newValue) {
            if (oldValue != null) {
                oldValue.uninstall(GlassedPane.this);
            }
            if (newValue != null) {
                newValue.install(GlassedPane.this);
            }
        }
    };

    public GlassedPane() {
        this.setLayout(null);
        this.contentPane.setOpaque(false);
        this.setOpaque(false);
        this.add(this.glassPane);
        this.add(this.contentPane);
        this.setFocusCycleRoot(true);
    }

    public void setController(DockController controller) {
        this.controller = controller;
        this.tooltips.setProperties(controller);
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.contentPane != null) {
            this.contentPane.setBounds(0, 0, width, height);
        }
        this.glassPane.setBounds(0, 0, width, height);
    }

    public Dimension getPreferredSize() {
        if (this.contentPane == null) {
            return super.getPreferredSize();
        }
        return this.contentPane.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.contentPane == null) {
            return super.getMaximumSize();
        }
        return this.contentPane.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.contentPane == null) {
            return super.getMinimumSize();
        }
        return this.contentPane.getMinimumSize();
    }

    public void setContentPane(JComponent contentPane) {
        this.contentPane = contentPane;
        this.removeAll();
        this.add(this.glassPane);
        if (contentPane != null) {
            this.add(contentPane);
        }
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public class GlassPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component dragged;
        private Component over;
        private int downCount = 0;
        private TooltipStrategyCallback callback = new TooltipStrategyCallback(){

            public void setToolTipText(String text) {
                GlassPane.this.setToolTipText(text);
            }

            public String getToolTipText() {
                return GlassPane.this.getToolTipText();
            }

            public GlassedPane getGlassedPane() {
                return GlassedPane.this;
            }

            public JToolTip createToolTip() {
                return GlassPane.this.superCreateToolTip();
            }
        };

        public GlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setOpaque(false);
            this.setFocusable(false);
            Workarounds.getDefault().markAsGlassPane(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!e.isConsumed() && this.isVisible()) {
                this.send(e);
            }
            if (!this.isVisible()) {
                this.downCount = 0;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        private void send(MouseEvent e) {
            this.send(e, e.getID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(MouseEvent e, int id) {
            if (!GlassedPane.this.onSending) {
                try {
                    GlassedPane.this.onSending = true;
                    this.sendNow(e, id);
                }
                finally {
                    GlassedPane.this.onSending = false;
                }
            }
        }

        private void sendNow(MouseEvent e, int id) {
            boolean exited;
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point mouse = e.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, mouse.x, mouse.y);
            component = component != null && !component.isEnabled() ? null : this.fallThrough(component, e);
            boolean drag = id == 506;
            boolean press = id == 501;
            boolean release = id == 502;
            boolean moved = id == 503;
            boolean entered = id == 504;
            boolean bl = exited = id == 505;
            if (drag && this.dragged == null) {
                this.dragged = component;
            } else if (drag) {
                component = this.dragged;
            }
            if (press) {
                this.downCount |= 1 << e.getButton();
            }
            if (this.downCount > 0 && this.dragged != null) {
                component = this.dragged;
            } else if (this.downCount > 0 && this.dragged == null) {
                this.dragged = component;
            } else if (this.downCount == 0) {
                this.dragged = null;
            }
            if (release) {
                this.downCount &= ~(1 << e.getButton());
            }
            if ((e.getModifiersEx() & 0x1C00) == 0) {
                this.downCount = 0;
                this.dragged = null;
            }
            boolean overNewComponent = false;
            if ((moved || entered || exited) && this.over != component) {
                Point overMouse;
                overNewComponent = true;
                if (this.over != null) {
                    overMouse = SwingUtilities.convertPoint(this, mouse, this.over);
                    this.over.dispatchEvent(new MouseEvent(this.over, 505, e.getWhen(), e.getModifiers(), overMouse.x, overMouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
                this.over = component;
                if (this.over != null) {
                    overMouse = SwingUtilities.convertPoint(this, mouse, this.over);
                    this.over.dispatchEvent(new MouseEvent(this.over, 504, e.getWhen(), e.getModifiers(), overMouse.x, overMouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
            if (component == null) {
                this.setCursor(null);
                this.setToolTipText(null);
            } else {
                mouse = SwingUtilities.convertPoint(this, mouse, component);
                MouseEvent forward = new MouseEvent(component, id, e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getGlobalMouseDispatcher().dispatch(forward);
                }
                component.dispatchEvent(forward);
                Cursor cursor = component.getCursor();
                if (this.getCursor() != cursor) {
                    this.setCursor(cursor);
                }
                ((TooltipStrategy)GlassedPane.this.tooltips.getValue()).setTooltipText(this.over, forward, overNewComponent, this.callback);
            }
        }

        private Component fallThrough(Component component, MouseEvent event) {
            Class type = null;
            type = event.getID() == 506 || event.getID() == 503 ? MouseMotionListener.class : (event.getID() == 507 ? MouseWheelListener.class : MouseListener.class);
            while (component != null && component.getListeners(type).length == 0) {
                component = component.getParent();
            }
            return component;
        }

        public JToolTip createToolTip() {
            return ((TooltipStrategy)GlassedPane.this.tooltips.getValue()).createTooltip(this.over, this.callback);
        }

        private JToolTip superCreateToolTip() {
            return super.createToolTip();
        }

        private void send(MouseWheelEvent e) {
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point mouse = e.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, mouse.x, mouse.y);
            if (component != null) {
                mouse = SwingUtilities.convertPoint(this, mouse, component);
                MouseWheelEvent forward = new MouseWheelEvent(component, e.getID(), e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getGlobalMouseDispatcher().dispatch(forward);
                }
                component.dispatchEvent(forward);
            }
        }
    }
}

