/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.ScreenDockDialog;
import bibliothek.gui.dock.station.screen.window.ScreenDockFrame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class DefaultScreenDockFullscreenStrategy
implements ScreenDockFullscreenStrategy {
    public void install(ScreenDockStation station) {
    }

    public void uninstall(ScreenDockStation station) {
    }

    public boolean isFullscreen(ScreenDockWindow window) {
        if (window instanceof ScreenDockDialog) {
            return this.isFullscreen(window, ((ScreenDockDialog)window).getDialog());
        }
        if (window instanceof ScreenDockFrame) {
            return this.isFullscreen(window, ((ScreenDockFrame)window).getFrame());
        }
        return false;
    }

    public boolean isFullscreen(ScreenDockWindow wrapper, Window window) {
        if (wrapper.getNormalBounds() == null) {
            return false;
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle current = window.getBounds();
        current = new Rectangle(current.x - 1, current.y - 1, current.width + 2, current.height + 2);
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle fullscreen = this.getAvailableBounds(device.getDefaultConfiguration());
            if (!current.contains(fullscreen)) continue;
            return true;
        }
        return false;
    }

    public void setFullscreen(ScreenDockWindow window, boolean fullscreen) {
        if (window instanceof ScreenDockDialog) {
            this.setFullscreen(window, ((ScreenDockDialog)window).getDialog(), fullscreen);
        }
        if (window instanceof ScreenDockFrame) {
            this.setFullscreen(window, ((ScreenDockFrame)window).getFrame(), fullscreen);
        }
    }

    public void setFullscreen(ScreenDockWindow wrapper, Window window, boolean fullscreen) {
        if (this.isFullscreen(wrapper, window) != fullscreen) {
            if (fullscreen) {
                Rectangle bounds = this.findBestFullscreenBounds(window);
                if (bounds != null) {
                    wrapper.setNormalBounds(wrapper.getWindowBounds());
                    window.setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
                }
            } else {
                Rectangle bounds = wrapper.getNormalBounds();
                if (bounds != null) {
                    window.setBounds(bounds);
                    wrapper.setNormalBounds(null);
                }
            }
        }
    }

    protected Rectangle findBestFullscreenBounds(Window window) {
        GraphicsDevice[] devices;
        Rectangle current = window.getBounds();
        for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(current)) continue;
            return this.getAvailableBounds(device.getDefaultConfiguration());
        }
        Point center = new Point(current.x + current.width / 2, current.y + current.height / 2);
        GraphicsDevice best = null;
        int bestDist = 0;
        for (GraphicsDevice device : devices) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            int dist = this.dist(bounds.x, bounds.width, center.x) + this.dist(bounds.y, bounds.height, center.y);
            if (best != null && dist >= bestDist) continue;
            best = device;
            bestDist = dist;
        }
        if (best != null) {
            return this.getAvailableBounds(best.getDefaultConfiguration());
        }
        return null;
    }

    protected Rectangle getAvailableBounds(GraphicsConfiguration configuration) {
        Rectangle bounds = configuration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(configuration);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    private int dist(int x, int width, int pos) {
        if (pos < x) {
            return x - pos;
        }
        if (pos > x + width) {
            return pos - x - width;
        }
        return 0;
    }
}

