/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulationControlCommand;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorManager;
import de.renew.application.StartSimulationCommand;
import de.renew.database.SetupHelper;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ConcurrentSimulator;
import de.renew.engine.simulator.InheritableSimulationThreadLock;
import de.renew.engine.simulator.NonConcurrentSimulator;
import de.renew.engine.simulator.ParallelSimulator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.net.IDRegistry;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.Finder;
import de.renew.net.loading.NetLoader;
import de.renew.net.loading.PathlessFinder;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.DefaultCompiledNetLoader;
import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.shadow.SNSFinder;
import de.renew.shadow.SequentialOnlyExtension;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.SingletonException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SimulatorPlugin
extends PluginAdapter
implements SimulatorManager {
    private static final Logger LOGGER = Logger.getLogger(SimulatorPlugin.class);
    private static final Object SINGLETON_LOCK = new Object();
    private static SimulatorPlugin _singleton = null;
    private final Queue<SimulatorExtension> _extensions = new ConcurrentLinkedQueue<SimulatorExtension>();
    private SimulationEnvironment _currentSimulation = null;
    private boolean _virginSimulation;
    private DefaultShadowNetLoader _currentShadowNetLoader = null;
    private NetLoader _nextNetLoader = null;
    private final Set<Finder> _registeredFinders = Collections.synchronizedSet(new HashSet());
    private final Set<PathlessFinder> _registeredPathlessFinders = new HashSet<PathlessFinder>();
    private boolean _previousClassReinit = false;
    private SimulationThreadPool _simulationThreadPool;
    @Deprecated
    public static final InheritableSimulationThreadLock lock = new InheritableSimulationThreadLock();
    private static final int STATE_STREAM_VERSION = 9;
    private static final String STATE_STREAM_LABEL = "RenewState";
    private static final String MAIN_PACKAGE_NAME = "de.renew.simulator";
    private static final String SIMULATION_CONTROL_COMMAND = "simulation";
    private static final String SIMULATION_START_COMMAND = "startsimulation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimulatorPlugin(PluginProperties props) {
        super(props);
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (_singleton != null) {
                throw new SingletonException("At most one instance of SimulatorPlugin is allowed.");
            }
            _singleton = this;
        }
        this._simulationThreadPool = SimulationThreadPool.getCurrent();
    }

    private void checkSingleton() {
        if (_singleton != this) {
            throw new SingletonException();
        }
    }

    private void checkSimulation() throws NoSimulationException {
        if (this._currentSimulation == null || this._currentSimulation.getSimulator() == null) {
            throw new NoSimulationException();
        }
    }

    private void checkNoSimulation() throws SimulationRunningException {
        if (this._currentSimulation != null) {
            throw new SimulationRunningException();
        }
    }

    public void init() {
        this.checkSingleton();
        this.setDefaultNetLoader();
        this.registerDefaultNetFinder(new SNSFinder());
        PluginManager.getInstance().addCLCommand(SIMULATION_START_COMMAND, (CLCommand)new StartSimulationCommand(this));
        PluginManager.getInstance().addCLCommand(SIMULATION_CONTROL_COMMAND, (CLCommand)new SimulationControlCommand(this));
    }

    public static InheritableSimulationThreadLock getLock() {
        return lock;
    }

    @Override
    public void addExtension(SimulatorExtension ext) {
        this.checkSingleton();
        LOGGER.debug((Object)("SimulatorPlugin: Registering extension " + String.valueOf(ext) + "."));
        this._extensions.add(ext);
    }

    @Override
    public void removeExtension(SimulatorExtension ext) {
        this.checkSingleton();
        LOGGER.debug((Object)("SimulatorPlugin: Deregistering extension " + String.valueOf(ext) + "."));
        this._extensions.remove(ext);
    }

    @Override
    public void setupSimulation(Properties props) {
        this.checkSingleton();
        lock.lock();
        try {
            SimulationThreadPool.getNew().executeAndWait(() -> {
                try {
                    this.checkNoSimulation();
                }
                catch (SimulationRunningException e) {
                    SimulationThreadPool.discardNew();
                    throw e;
                }
                this.restartThreadPool();
                assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                Properties activeProperties = new Properties();
                activeProperties.putAll((Map<?, ?>)this.getProperties());
                if (props != null) {
                    activeProperties.putAll((Map<?, ?>)props);
                }
                int maxPriority = PropertyHelper.getIntProperty((Properties)activeProperties, (String)"de.renew.simulatorPriority", (int)5);
                if (this._simulationThreadPool.getMaxPriority() != maxPriority) {
                    this._simulationThreadPool.setMaxPriority(maxPriority);
                }
                SimulatorEventQueue.initialize();
                LOGGER.debug((Object)"SimulatorPlugin: Setting up simulation.");
                SimulatorExtension[] activeExtensions = this._extensions.toArray(new SimulatorExtension[0]);
                this.possiblySetupClassSource(activeProperties);
                Net.forgetAllNets();
                Net.setNetLoader(this._nextNetLoader);
                if (this._nextNetLoader instanceof DelayedDelegationNetLoader) {
                    Set<Finder> set = this._registeredFinders;
                    synchronized (set) {
                        LOGGER.debug((Object)"SimulatorPlugin: Creating default shadow net loader.");
                        this._currentShadowNetLoader = new DefaultShadowNetLoader(activeProperties);
                        for (Finder finder : this._registeredFinders) {
                            this._currentShadowNetLoader.registerFinder(finder);
                        }
                        for (PathlessFinder pathlessFinder : this._registeredPathlessFinders) {
                            this._currentShadowNetLoader.registerPathlessFinder(pathlessFinder);
                        }
                    }
                    LOGGER.debug((Object)"SimulatorPlugin: Configuring delayed net loader.");
                    ((DelayedDelegationNetLoader)this._nextNetLoader).setNetLoader(new DefaultCompiledNetLoader(this._currentShadowNetLoader));
                }
                Simulator simulator = SimulatorPlugin.newSimulator(activeProperties);
                this._currentSimulation = new SimulationEnvironment(simulator, activeExtensions, activeProperties);
                this._virginSimulation = true;
                for (SimulatorExtension activeExtension : activeExtensions) {
                    activeExtension.simulationSetup(this._currentSimulation);
                }
                PluginManager.getInstance().blockExit((IPlugin)SimulatorPlugin.getCurrent());
            });
        }
        finally {
            lock.unlock();
        }
    }

    private static Simulator newSimulator(Properties props) {
        Simulator simulator;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int simulatorMode = PropertyHelper.getIntProperty((Properties)props, (String)"de.renew.simulatorMode", (int)1);
        int simulatorMultiplicity = PropertyHelper.getIntProperty((Properties)props, (String)"de.renew.simulatorMultiplicity", (int)1);
        Class simulatorClass = PropertyHelper.getClassProperty((Properties)props, (String)"de.renew.simulatorClass", Simulator.class);
        if (simulatorClass != null) {
            LOGGER.info((Object)("Using simulator class " + simulatorClass.getName() + " with " + simulatorMultiplicity + " simulators ..."));
        } else if (simulatorMode == 1) {
            simulatorClass = ConcurrentSimulator.class;
            LOGGER.info((Object)"Using default concurrent simulator ...");
        } else if (simulatorMode == 0 || simulatorMode == -1) {
            simulatorClass = NonConcurrentSimulator.class;
            LOGGER.info((Object)"Using sequential simulator ...");
        } else {
            simulatorClass = ParallelSimulator.class;
            simulatorMultiplicity = simulatorMode;
            if (simulatorMultiplicity < 0) {
                LOGGER.warn((Object)("Using " + -simulatorMultiplicity + " sequential simulators ..."));
            } else {
                LOGGER.warn((Object)("Using " + simulatorMultiplicity + " concurrent simulators ..."));
            }
            LOGGER.warn((Object)"Caution! This is an experimental feature!");
        }
        boolean eagerSimulation = PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.eagerSimulation");
        if (eagerSimulation) {
            LOGGER.info((Object)"Using eager simulation mode.");
        }
        try {
            try {
                simulator = (Simulator)simulatorClass.getConstructor(Integer.TYPE, Boolean.TYPE).newInstance(simulatorMultiplicity, !eagerSimulation);
            }
            catch (NoSuchMethodException e) {
                simulator = (Simulator)simulatorClass.getConstructor(Boolean.TYPE).newInstance(!eagerSimulation);
                simulatorMultiplicity = simulator.isSequential() ? 0 : 1;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error((Object)"Encountered exception when trying to instantiate simulator class:", (Throwable)e);
            simulator = new ConcurrentSimulator(!eagerSimulation);
            simulatorClass = ConcurrentSimulator.class;
            simulatorMultiplicity = 1;
        }
        props.setProperty("de.renew.simulatorClass", simulatorClass.getName());
        props.setProperty("de.renew.simulatorMultiplicity", Integer.toString(simulatorMultiplicity));
        return simulator;
    }

    @Override
    public boolean isSimulationActive() {
        this.checkSingleton();
        return this._currentSimulation != null && this._currentSimulation.getSimulator().isActive();
    }

    @Override
    public SimulationEnvironment getCurrentEnvironment() {
        return this._currentSimulation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShadowLookup insertNets(ShadowNetSystem netSystem) throws SyntaxException, NoSimulationException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<ShadowLookup> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                SimulatorExtension[] activeExtensions;
                ShadowLookup lookup;
                this.checkSimulation();
                Objects.requireNonNull(netSystem, "Missing shadow net system.");
                ShadowNetLoader netLoader = netSystem.getNetLoader();
                if (netLoader == null && this._currentShadowNetLoader != null) {
                    LOGGER.debug((Object)"SimulatorPlugin: Applying default shadow net loader to net system.");
                    netSystem.setNetLoader(this._currentShadowNetLoader);
                }
                if (this._virginSimulation) {
                    LOGGER.debug((Object)"SimulatorPlugin: Compiling first net system.");
                    lookup = netSystem.compile();
                } else {
                    LOGGER.debug((Object)"SimulatorPlugin: Adding another net system.");
                    lookup = netSystem.compileMore();
                }
                LOGGER.debug((Object)("SimulatorPlugin: Compilation result lookup: " + String.valueOf(lookup)));
                SequentialOnlyExtension seqEx = SequentialOnlyExtension.lookup(lookup);
                boolean sequentialOnly = seqEx.getSequentialOnly();
                if (sequentialOnly && !this._currentSimulation.getSimulator().isSequential()) {
                    throw new SyntaxException("Some nets need a sequential simulator.");
                }
                this._virginSimulation = false;
                for (SimulatorExtension activeExtension : activeExtensions = this._currentSimulation.getExtensions()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(SimulatorPlugin.class.getName() + ": Active Extension compile net " + activeExtension.toString()));
                    }
                    activeExtension.netsCompiled(lookup);
                }
                lookup.makeNetsKnown();
                return lookup;
            });
            ShadowLookup shadowLookup = future.get();
            return shadowLookup;
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)"Simulation ended");
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SyntaxException) {
                SyntaxException exc = (SyntaxException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetupHelper.SimulationState restoreStateFromDatabase() {
        this.checkSingleton();
        lock.lock();
        try {
            Future<SetupHelper.SimulationState> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                this.checkSimulation();
                return SetupHelper.setup(this._currentSimulation.getProperties());
            });
            SetupHelper.SimulationState simulationState = future.get();
            return simulationState;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(ObjectOutput output, NetInstance[] instances) throws IOException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<Object> future = this._simulationThreadPool.submitAndWait(() -> {
                this.checkSimulation();
                this._currentSimulation.getSimulator().stopRun();
                RenewObjectOutputStream rOut = null;
                if (output instanceof RenewObjectOutputStream) {
                    rOut = (RenewObjectOutputStream)output;
                }
                if (rOut != null) {
                    rOut.beginDomain(SimulatorPlugin.class);
                }
                output.writeObject(STATE_STREAM_LABEL);
                output.writeInt(9);
                output.writeInt(PropertyHelper.getIntProperty((Properties)this._currentSimulation.getProperties(), (String)"de.renew.simulatorMultiplicity"));
                output.writeInt(instances.length);
                for (NetInstance instance : instances) {
                    output.writeObject(instance);
                }
                if (rOut != null) {
                    rOut.writeDelayedObjects();
                }
                Net.saveAllNets(output);
                SearchQueue.saveQueue(output);
                IDRegistry.save(output);
                if (rOut != null) {
                    rOut.endDomain(SimulatorPlugin.class);
                }
                return null;
            });
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                IOException exc = (IOException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetInstance[] loadState(ObjectInput input, Properties props) throws IOException, ClassNotFoundException, SimulationRunningException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<NetInstance[]> future = SimulationThreadPool.getNew().submitAndWait(() -> {
                ArrayList<NetInstance> explicitInstances;
                try {
                    LOGGER.debug((Object)"Loading simulation state...");
                    this.setupSimulation(props);
                    String streamLabel = (String)input.readObject();
                    if (!streamLabel.equals(STATE_STREAM_LABEL)) {
                        throw new StreamCorruptedException("Stream does not seem to contain renew state data.");
                    }
                    int streamVersion = input.readInt();
                    if (streamVersion != 9) {
                        throw new StreamCorruptedException("State data is of different version (" + streamVersion + ") than the current version (9).");
                    }
                    int simulatorMultiplicity = PropertyHelper.getIntProperty((Properties)this._currentSimulation.getProperties(), (String)"de.renew.simulatorMultiplicity", (int)1);
                    int streamSimulatorMultiplicity = input.readInt();
                    if (streamSimulatorMultiplicity != simulatorMultiplicity) {
                        LOGGER.warn((Object)("Simulation state was saved using a different simulator multiplicity (" + streamSimulatorMultiplicity + ") than currently selected (" + simulatorMultiplicity + ")."));
                    }
                    int count = input.readInt();
                    explicitInstances = new ArrayList<NetInstance>(count);
                    try {
                        for (int i = 0; i < count; ++i) {
                            explicitInstances.add((NetInstance)ClassSource.readObject((ObjectInput)input));
                        }
                    }
                    catch (ClassCastException e) {
                        LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                        throw new StreamCorruptedException("Object other than NetInstance found when looking for net instances: " + e.getMessage());
                    }
                    if (input instanceof RenewObjectInputStream) {
                        ((RenewObjectInputStream)input).readDelayedObjects();
                    }
                    Net.loadNets(input);
                    SearchQueue.loadQueue(input);
                    IDRegistry.load(input);
                }
                catch (IOException e) {
                    this.terminateSimulation();
                    throw e;
                }
                catch (ClassNotFoundException | StackOverflowError e) {
                    this.terminateSimulation();
                    throw e;
                }
                return explicitInstances.toArray(new NetInstance[0]);
            });
            NetInstance[] netInstanceArray = future.get();
            return netInstanceArray;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SimulationRunningException) {
                throw new SimulationRunningException(e);
            }
            if (t instanceof IOException) {
                IOException exc = (IOException)t;
                throw exc;
            }
            if (t instanceof ClassNotFoundException) {
                throw new ClassNotFoundException(t.getMessage(), e);
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    @Override
    public synchronized void setNetLoader(NetLoader loader) {
        this.checkSingleton();
        LOGGER.debug((Object)("SimulatorPlugin: Configuring net loader " + String.valueOf(loader) + "."));
        this._nextNetLoader = loader;
    }

    @Override
    public synchronized void setDefaultNetLoader() {
        this.setNetLoader(new DelayedDelegationNetLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDefaultNetFinder(Finder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredFinders.add(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.registerFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefaultNetFinder(Finder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredFinders.remove(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.removeFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDefaultPathlessFinder(PathlessFinder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredPathlessFinders.add(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.registerPathlessFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefaultPathlessFinder(PathlessFinder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredPathlessFinders.remove(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.removePathlessFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetInstance createNetInstance(String net) throws NetNotFoundException, NoSimulationException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<NetInstance> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                Net netTemplate;
                NetInstance netInstance = null;
                this.checkSimulation();
                if (net != null && (netTemplate = Net.forName(net)) != null) {
                    netInstance = netTemplate.buildInstance(this._currentSimulation.getSimulator().nextStepIdentifier());
                    this._currentSimulation.getSimulator().refresh();
                }
                return netInstance;
            });
            NetInstance netInstance = future.get();
            return netInstance;
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)"Creation of NetInstances was aborted");
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NetNotFoundException) {
                NetNotFoundException exc = (NetNotFoundException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    @Override
    public void terminateSimulation() {
        this.checkSingleton();
        lock.lock();
        try {
            SimulationThreadPool.getCurrent().executeAndWait(() -> {
                if (this._currentSimulation != null) {
                    SimulatorExtension[] exts;
                    LOGGER.debug((Object)"SimulatorPlugin: Stopping simulation.");
                    for (SimulatorExtension ext : exts = this._currentSimulation.getExtensions()) {
                        ext.simulationTerminating();
                    }
                    this._currentSimulation.getSimulator().terminateRun();
                    for (SimulatorExtension ext : exts = this._currentSimulation.getExtensions()) {
                        ext.simulationTerminated();
                    }
                    SearchQueue.reset(0.0);
                    IDRegistry.reset();
                    Net.forgetAllNets();
                    PluginManager.getInstance().exitOk((IPlugin)SimulatorPlugin.getCurrent());
                    this._currentSimulation = null;
                    this._currentShadowNetLoader = null;
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    private void restartThreadPool() {
        SimulationThreadPool.cleanup();
        this._simulationThreadPool = SimulationThreadPool.getSimulationThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cleanup() {
        this.setNetLoader(null);
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            this.checkSingleton();
            this.terminateSimulation();
            _singleton = null;
        }
        PluginManager.getInstance().removeCLCommand(SIMULATION_START_COMMAND);
        PluginManager.getInstance().removeCLCommand(SIMULATION_CONTROL_COMMAND);
        SimulationThreadPool.cleanup();
        this._simulationThreadPool = null;
        return true;
    }

    public boolean canShutDown() {
        this.checkSingleton();
        return true;
    }

    public <T> T submitAndWait(Callable<T> task) throws InterruptedException {
        this.checkSingleton();
        lock.lock();
        try {
            this.checkSimulation();
            Future<T> futureObj = this._simulationThreadPool.submitAndWait(task);
            T t = futureObj.get();
            return t;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)("Simulation thread threw an exception: " + String.valueOf(t)), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void possiblySetupClassSource(Properties props) throws IllegalStateException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<Object> result = this._simulationThreadPool.submitAndWait(() -> {
                if (this.isSimulationActive()) {
                    throw new IllegalStateException("Reconfiguration of class source is not allowed while a simulation is running.");
                }
                boolean classReinit = PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.classReinit");
                if (classReinit) {
                    if (!this._previousClassReinit) {
                        LOGGER.info((Object)"Using classReinit mode.");
                    } else {
                        LOGGER.debug((Object)"SimulatorPlugin: Re-initialising class loader.");
                    }
                    ClassLoader classLoader = PluginManager.getInstance().getNewBottomClassLoader();
                    ClassSource.setClassLoader((ClassLoader)classLoader);
                } else if (this._previousClassReinit) {
                    LOGGER.debug((Object)"classReinit mode disabled.");
                    ClassSource.setClassLoader(null);
                }
                this._previousClassReinit = classReinit;
                return null;
            });
            result.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalStateException) {
                IllegalStateException exc = (IllegalStateException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public static SimulatorPlugin getCurrent() {
        for (IPlugin plugin : PluginManager.getInstance().getPluginsProviding(MAIN_PACKAGE_NAME)) {
            if (!(plugin instanceof SimulatorPlugin)) continue;
            return (SimulatorPlugin)plugin;
        }
        return _singleton;
    }

    private static class DelayedDelegationNetLoader
    implements NetLoader {
        private NetLoader _netLoader = null;

        private DelayedDelegationNetLoader() {
        }

        public void setNetLoader(NetLoader netLoader) {
            this._netLoader = netLoader;
        }

        @Override
        public Net loadNet(String netName) throws NetNotFoundException {
            if (this._netLoader == null) {
                throw new NetNotFoundException("No net loader configured.");
            }
            return this._netLoader.loadNet(netName);
        }
    }
}

