/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.unify.Impossible;

class ActionExecutable
implements LateExecutable {
    final Expression expression;
    final VariableMapper mapper;

    ActionExecutable(Expression expression, VariableMapper mapper) {
        this.expression = expression;
        this.mapper = mapper;
    }

    @Override
    public int phase() {
        return 2;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            this.expression.startEvaluation(this.mapper, null, null);
        }
        catch (Impossible e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new RuntimeException("Action exception in step " + String.valueOf(stepIdentifier) + ": " + e.getMessage(), cause);
        }
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
    }
}

