/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.TransitionException;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.BindingList;
import de.renew.engine.simulator.PhaseComparator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.util.Detacher;
import de.renew.util.LockComparator;
import de.renew.util.Semaphor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class Binding
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Binding.class);
    private List<EarlyExecutable> _earlyExecutables = new ArrayList<EarlyExecutable>();
    private List<LateExecutable> _lateExecutables = new ArrayList<LateExecutable>();
    private final OccurrenceDescription[] _occurrenceDescriptions;
    private String _description;
    private boolean _result = false;
    private final Semaphor _semaphore = new Semaphor();
    private StepIdentifier _stepIdentifier = null;

    public Binding(Searcher searcher) {
        Copier copier = new Copier();
        VariableMapperCopier variableMapperCopier = new VariableMapperCopier(copier);
        ArrayList<Executable> executables = new ArrayList<Executable>();
        Collection<Occurrence> occurrences = searcher.getOccurrences();
        for (Occurrence occurrence2 : occurrences) {
            executables.addAll(occurrence2.makeExecutables(variableMapperCopier));
        }
        for (Executable executable : executables) {
            if (executable instanceof EarlyExecutable) {
                EarlyExecutable earlyExecutable = (EarlyExecutable)executable;
                this._earlyExecutables.add(earlyExecutable);
                continue;
            }
            if (executable instanceof LateExecutable) {
                LateExecutable lateExecutable = (LateExecutable)executable;
                this._lateExecutables.add(lateExecutable);
                continue;
            }
            throw new RuntimeException("Unknown type of executable detected: " + String.valueOf(executable));
        }
        this._occurrenceDescriptions = (OccurrenceDescription[])occurrences.stream().map(occurrence -> occurrence.makeOccurrenceDescription(variableMapperCopier)).toArray(OccurrenceDescription[]::new);
    }

    private String makeText() {
        return Arrays.stream(this._occurrenceDescriptions).map(OccurrenceDescription::getDescription).collect(Collectors.joining("\n"));
    }

    public String getDescription() {
        if (this._description == null) {
            this._description = this.makeText();
        }
        return this._description;
    }

    public synchronized boolean execute(StepIdentifier stepIdentifier, boolean asynchronous) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._earlyExecutables == null) {
            throw new RuntimeException("Cannot execute binding twice.");
        }
        this._stepIdentifier = stepIdentifier;
        if (asynchronous) {
            SimulationThreadPool.getCurrent().execute(this);
        } else {
            SimulationThreadPool.getCurrent().executeAndWait(this);
        }
        SimulatorEventLogger.log(stepIdentifier, "-------- Synchronously --------");
        this._semaphore.P();
        return this._result;
    }

    private void lock() {
        for (EarlyExecutable earlyExecutable : this._earlyExecutables) {
            earlyExecutable.lock();
        }
    }

    private void unlock() {
        for (EarlyExecutable earlyExecutable : this._earlyExecutables) {
            earlyExecutable.unlock();
        }
    }

    private boolean verify(StepIdentifier stepIdentifier) {
        ArrayList<EarlyExecutable> verified = new ArrayList<EarlyExecutable>();
        try {
            for (EarlyExecutable earlyExecutable : this._earlyExecutables) {
                earlyExecutable.verify(stepIdentifier);
                verified.add(earlyExecutable);
            }
        }
        catch (Impossible e) {
            TransactionSource.rollback();
            Collections.reverse(verified);
            verified.forEach(EarlyExecutable::rollback);
            return false;
        }
        return true;
    }

    private void executeEarly(StepIdentifier stepIdentifier) {
        for (EarlyExecutable earlyExecutable : this._earlyExecutables) {
            earlyExecutable.execute(stepIdentifier);
        }
    }

    private void executeLate(StepIdentifier stepIdentifier) {
        Throwable firstThrowable = null;
        for (LateExecutable lateExecutable : this._lateExecutables) {
            if (lateExecutable.isLong()) {
                Detacher.detach();
            }
            try {
                if (firstThrowable == null) {
                    lateExecutable.execute(stepIdentifier);
                    continue;
                }
                lateExecutable.executeAfterException(stepIdentifier, firstThrowable);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                SimulatorEventLogger.log(stepIdentifier, new TransitionException(t));
                LOGGER.error((Object)t.getMessage(), t);
            }
        }
    }

    @Override
    public void run() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        BindingList.register(this);
        TransactionSource.start();
        this._earlyExecutables.sort((Comparator<EarlyExecutable>)new LockComparator());
        this.lock();
        try {
            this._earlyExecutables.sort(new PhaseComparator());
            this._result = this.verify(this._stepIdentifier);
            if (this._result) {
                this.executeEarly(this._stepIdentifier);
            }
        }
        finally {
            this.unlock();
        }
        this._semaphore.V();
        if (this._result) {
            this._lateExecutables.sort(new PhaseComparator());
            this.executeLate(this._stepIdentifier);
            try {
                TransactionSource.commit();
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        BindingList.remove(this);
        this._earlyExecutables = null;
        this._lateExecutables = null;
    }
}

