/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.simulator.ConcurrentChildSimulator;
import de.renew.engine.simulator.NonConcurrentChildSimulator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ParallelSimulator
implements Simulator {
    private static final Logger LOGGER = Logger.getLogger(ParallelSimulator.class);
    private static long _runCounter = 0L;
    private long _cycle = 0L;
    private final long _simulationRunId;
    private long[] _collectedSimulationRunIds;
    private final Simulator[] _simulators;

    public ParallelSimulator(int multiplicity, boolean wantEventQueueDelay) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (multiplicity == 0) {
            multiplicity = 1;
        }
        boolean wantConcurrent = multiplicity > 0;
        multiplicity = Math.abs(multiplicity);
        this._simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + _runCounter++;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this._simulationRunId));
        }
        this._simulators = new Simulator[multiplicity];
        for (int i = 0; i < multiplicity; ++i) {
            this._simulators[i] = wantConcurrent ? new ConcurrentChildSimulator(wantEventQueueDelay, this) : new NonConcurrentChildSimulator(wantEventQueueDelay, this);
        }
        this.collectAllRunIds();
    }

    private void collectAllRunIds() {
        ArrayList<Long> allRunIds = new ArrayList<Long>();
        allRunIds.add(this._simulationRunId);
        for (Simulator simulator : this._simulators) {
            for (long runId : simulator.collectSimulationRunIds()) {
                allRunIds.add(runId);
            }
        }
        this._collectedSimulationRunIds = allRunIds.stream().mapToLong(Long::longValue).toArray();
    }

    @Override
    public boolean isActive() {
        return Arrays.stream(this._simulators).anyMatch(Simulator::isActive);
    }

    @Override
    public synchronized void startRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> Arrays.stream(this._simulators).forEach(Simulator::startRun));
    }

    @Override
    public void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> Arrays.stream(this._simulators).forEach(Simulator::stopRun));
    }

    @Override
    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> Arrays.stream(this._simulators).forEach(Simulator::terminateRun));
    }

    @Override
    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
            Arrays.stream(this._simulators).forEach(Simulator::stopRun);
            int status = 0;
            for (Simulator simulator : this._simulators) {
                status = simulator.step();
                if (status != 1 && status != 2) continue;
                return status;
            }
            return status;
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return -1;
    }

    @Override
    public void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> Arrays.stream(this._simulators).forEach(Simulator::refresh));
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{++this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        return Arrays.copyOf(this._collectedSimulationRunIds, this._collectedSimulationRunIds.length);
    }
}

