/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.arc.Arc;
import de.renew.net.arc.ArcAssignBinder;
import de.renew.net.arc.InhibitorArcBinder;
import de.renew.net.arc.InhibitorExecutable;
import de.renew.net.arc.InputArcBinder;
import de.renew.net.arc.InputArcExecutable;
import de.renew.net.arc.OutputArcExecutable;
import de.renew.net.arc.TestArcBinder;
import de.renew.net.arc.TestArcExecutable;
import de.renew.net.arc.UntestArcExecutable;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class ArcOccurrence
extends AbstractOccurrence {
    static Variable theNullTimeVar = new Variable(new Value((Object)0.0), null);
    SimulatablePlaceInstance placeInstance;
    VariableMapper mapper;
    Variable tokenVar;
    Variable delayVar;
    Arc arc;

    protected ArcOccurrence(Arc arc, VariableMapper mapper, NetInstance netInstance) {
        super(netInstance.getInstance(arc.transition));
        this.arc = arc;
        this.mapper = mapper;
        this.placeInstance = (SimulatablePlaceInstance)netInstance.getInstance(arc.place);
    }

    protected InhibitorArcBinder getInhibitorArcBinder(Variable tokenVar, SimulatablePlaceInstance placeInstance) {
        return new InhibitorArcBinder(tokenVar, placeInstance);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        this.tokenVar = new Variable(this.arc.tokenExpr.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        if (!this.arc.isUntimedArc()) {
            this.delayVar = new Variable(this.arc.timeExpr.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        }
        ArrayList<Binder> binders = new ArrayList<Binder>();
        if (this.arc.arcType == 1) {
            searcher.calcChecker.addLateVariable(this.tokenVar, searcher.recorder);
            searcher.calcChecker.addLateVariable(this.delayVar, searcher.recorder);
        } else if (this.arc.arcType == 5) {
            binders.add(this.getInhibitorArcBinder(this.tokenVar, this.placeInstance));
        } else {
            if (this.arc.tokenExpr.isInvertible()) {
                binders.add(new ArcAssignBinder(this.tokenVar, this.placeInstance, this.arc.isTestArc()));
            }
            if (this.arc.isTestArc()) {
                binders.add(new TestArcBinder(this.tokenVar, this.placeInstance));
            } else if (this.arc.arcType == 6) {
                binders.add(new InputArcBinder(this.tokenVar, new Variable(0, null), this.placeInstance));
                searcher.calcChecker.addLateVariable(this.delayVar, searcher.recorder);
            } else {
                binders.add(new InputArcBinder(this.tokenVar, this.delayVar, this.placeInstance));
            }
        }
        return binders;
    }

    private double getDelay() {
        Object timeObj = this.delayVar.getValue();
        if (timeObj instanceof Value) {
            timeObj = ((Value)timeObj).value;
        }
        return ((Number)timeObj).doubleValue();
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        Copier copier = variableMapperCopier.getCopier();
        Variable copiedToken = (Variable)copier.copy(this.tokenVar);
        Vector<Executable> coll = new Vector<Executable>();
        switch (this.arc.arcType) {
            case -1: {
                coll.add(new InputArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), this.getDelay(), false, this.arc.getTrace()));
                return coll;
            }
            case 0: {
                TestArcExecutable tester = new TestArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), false, this.arc.getTrace());
                return Arrays.asList(tester, new UntestArcExecutable(tester));
            }
            case 1: {
                Variable copiedDelay = (Variable)copier.copy(this.delayVar);
                coll.add(new OutputArcExecutable(this.placeInstance, this.getTransition(), copiedToken, copiedDelay, this.arc.getTrace()));
                return coll;
            }
            case 2: {
                return Arrays.asList(new InputArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), this.getDelay(), false, this.arc.getTrace()), new OutputArcExecutable(this.placeInstance, this.getTransition(), copiedToken, null, this.arc.getTrace()));
            }
            case 3: {
                coll.add(new InputArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), this.getDelay(), true, this.arc.getTrace()));
                return coll;
            }
            case 4: {
                coll.add(new TestArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), true, this.arc.getTrace()));
                return coll;
            }
            case 5: {
                coll.add(new InhibitorExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), this.arc.getTrace()));
                return coll;
            }
            case 6: {
                Variable copiedDelay = (Variable)copier.copy(this.delayVar);
                return Arrays.asList(new InputArcExecutable(this.placeInstance, this.getTransition(), copiedToken.getValue(), 0.0, false, this.arc.getTrace()), new OutputArcExecutable(this.placeInstance, this.getTransition(), copiedToken, copiedDelay, this.arc.getTrace()));
            }
        }
        throw new RuntimeException("Bad arc type.");
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }
}

