/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.net.arc.FlexibleArc;
import de.renew.net.arc.InputArcExecutable;
import de.renew.unify.Impossible;
import java.util.Vector;

class FlexibleInArcExecutable
implements EarlyExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Vector<Object> tokens;
    FlexibleArc arc;
    int numRemoved;
    Vector<Double> removedTimes;

    FlexibleInArcExecutable(SimulatablePlaceInstance placeInstance, TransitionInstance tInstance, Vector<Object> tokens, FlexibleArc arc) {
        this.pInstance = placeInstance;
        this.tInstance = tInstance;
        this.tokens = tokens;
        this.arc = arc;
        this.numRemoved = 0;
        this.removedTimes = new Vector();
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -3;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        try {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Object token = this.tokens.elementAt(i);
                double removedTime = this.pInstance.removeToken(token, 0.0);
                this.removedTimes.addElement(removedTime);
                ++this.numRemoved;
            }
        }
        catch (Exception e) {
            this.rollback();
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        for (int i = 0; i < this.numRemoved; ++i) {
            Object token = this.tokens.elementAt(i);
            if (this.arc.arcType == 3) {
                if (this.arc.trace) {
                    InputArcExecutable.traceInArc(stepIdentifier, true, token, this.pInstance, this.tInstance);
                }
                this.pInstance.insertToken(token, SearchQueue.getTime());
                continue;
            }
            if (!this.arc.trace) continue;
            InputArcExecutable.traceInArc(stepIdentifier, false, token, this.pInstance, this.tInstance);
        }
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.numRemoved; ++i) {
            this.pInstance.internallyInsertToken(this.tokens.elementAt(i), this.removedTimes.elementAt(i), false);
        }
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

