/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.samples;

import de.renew.unify.Tuple;
import de.renew.util.Value;

public abstract class Topology {
    public abstract int[] nodes();

    public abstract int[] neighbors(int var1);

    public Tuple[] r(int x) {
        return Topology.prod(x, this.neighbors(x));
    }

    public Tuple[] N(int x) {
        return Topology.prod(this.neighbors(x), x);
    }

    public Tuple[] NI(int x) {
        return this.r(x);
    }

    public Tuple[] Q(int x) {
        return Topology.appendCart(this.N(x), "?");
    }

    public Tuple[] R(int x) {
        return Topology.appendCart(this.NI(x), "!");
    }

    public int[] complement(int[] subset) {
        int[] nodes = this.nodes();
        int complementSize = nodes.length - subset.length;
        if (complementSize < 0 || complementSize > nodes.length) {
            throw new IllegalArgumentException("Subset size violates constraint: 0 <= " + subset.length + " <= " + nodes.length);
        }
        int[] result = new int[complementSize];
        int fillpos = 0;
        for (int i = 0; i < nodes.length; ++i) {
            int nodeInQuestion = nodes[i];
            boolean isInSubset = false;
            for (int j = 0; j < subset.length && !isInSubset; ++j) {
                if (nodeInQuestion != subset[i]) continue;
                isInSubset = true;
            }
            if (isInSubset) continue;
            result[fillpos] = nodeInQuestion;
            ++fillpos;
        }
        return result;
    }

    public Tuple[] all() {
        int cnt = 0;
        int[] nodes = this.nodes();
        for (int i = 0; i < nodes.length; ++i) {
            cnt += this.neighbors(i).length;
        }
        Tuple[] result = new Tuple[cnt];
        cnt = 0;
        for (int i = 0; i < nodes.length; ++i) {
            int[] n = this.neighbors(i);
            for (int j = 0; j < n.length; ++j) {
                result[cnt++] = Topology.makePair(i, n[j]);
            }
        }
        return result;
    }

    public static Tuple makePair(int x, int y) {
        Object[] arr = new Object[]{new Value((Object)x), new Value((Object)y)};
        return new Tuple(arr, null);
    }

    public static void sort(int[] x) {
        for (int i = x.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (x[i] >= x[j]) continue;
                int h = x[i];
                x[i] = x[j];
                x[j] = h;
            }
        }
    }

    public static int[] union(int[] x, int[] y) {
        x = (int[])x.clone();
        y = (int[])y.clone();
        Topology.sort(x);
        Topology.sort(y);
        int[] temp = new int[x.length + y.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < x.length || j < y.length) {
            int t = i == x.length || j != y.length && x[i] > y[j] ? y[j++] : x[i++];
            if (k != 0 && t <= temp[k - 1]) continue;
            temp[k++] = t;
        }
        int[] result = new int[k];
        for (i = 0; i < k; ++i) {
            result[i] = temp[i];
        }
        return result;
    }

    public static Tuple[] cart(int[] x, int[] y) {
        Tuple[] result = new Tuple[x.length * y.length];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                result[i] = Topology.makePair(x[i], y[j]);
            }
        }
        return result;
    }

    public static Tuple[] appendCart(Tuple[] tuples, Object x) {
        Tuple[] result = new Tuple[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            int componentCount = tuples[i].getArity();
            Object[] arr = new Object[componentCount + 1];
            for (int j = 0; j < componentCount; ++j) {
                arr[j] = tuples[i].getComponent(j);
            }
            arr[componentCount] = x;
            result[i] = new Tuple(arr, null);
        }
        return result;
    }

    public static Tuple[] appendCart(Tuple[] tuples, int x) {
        Tuple[] result = new Tuple[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            int componentCount = tuples[i].getArity();
            Object[] arr = new Object[componentCount + 1];
            for (int j = 0; j < componentCount; ++j) {
                arr[j] = tuples[i].getComponent(j);
            }
            arr[componentCount] = new Value((Object)x);
            result[i] = new Tuple(arr, null);
        }
        return result;
    }

    public static Tuple[] prod(int[] x, int y) {
        Tuple[] result = new Tuple[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = Topology.makePair(x[i], y);
        }
        return result;
    }

    public static Tuple[] prod(int x, int[] y) {
        Tuple[] result = new Tuple[y.length];
        for (int i = 0; i < y.length; ++i) {
            result[i] = Topology.makePair(x, y[i]);
        }
        return result;
    }

    public static Tuple[] prod(int[] x, int[] y) {
        Tuple[] result = new Tuple[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = Topology.makePair(x[i], y[i]);
        }
        return result;
    }

    public static Tuple[] pairs(int[] x) {
        return Topology.prod(x, x);
    }

    public static Tuple[] exclude(Tuple[] set, Tuple toExclude) {
        if (set.length == 0) {
            return set;
        }
        Tuple[] result = new Tuple[set.length - 1];
        int skipIfFound = 0;
        for (int i = 0; i < result.length; ++i) {
            if (toExclude.equals(set[i + skipIfFound])) {
                assert (skipIfFound == 0) : "Encountered duplicate";
                skipIfFound = 1;
            }
            result[i] = set[i + skipIfFound];
        }
        if (skipIfFound == 0 && !toExclude.equals(set[result.length])) {
            return set;
        }
        return result;
    }

    public static int[] exclude(int[] set, int toExclude) {
        if (set.length == 0) {
            return set;
        }
        int[] result = new int[set.length - 1];
        int skipIfFound = 0;
        for (int i = 0; i < result.length; ++i) {
            if (toExclude == set[i + skipIfFound]) {
                assert (skipIfFound == 0) : "Encountered duplicate";
                skipIfFound = 1;
            }
            result[i] = set[i + skipIfFound];
        }
        if (skipIfFound == 0 && toExclude != set[result.length]) {
            return set;
        }
        return result;
    }
}

