/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Referable;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Unknown;
import de.renew.unify.Variable;
import java.io.Serializable;
import java.util.Set;

public class Reference
implements Serializable {
    private Object _value;
    private boolean _bound;
    private boolean _complete;
    private final Referer _referer;

    public Reference(Object value, Referer referer, StateRecorder recorder) {
        if (value instanceof Variable) {
            value = ((Variable)value).getValue();
        }
        this._value = value;
        this._complete = Unify.isComplete(value);
        this._bound = Unify.isBound(value);
        this._referer = referer;
        if (!this._complete && value instanceof Referable) {
            Referable referable = (Referable)value;
            referable.addBacklink(this, recorder);
        }
    }

    public void occursCheck(Unknown that, Set<IdentityWrapper> visited) throws Impossible {
        Object object = this._value;
        if (object instanceof Referable) {
            Referable referable = (Referable)object;
            referable.occursCheck(that, visited);
        }
    }

    public void update(Referable oldValue, Object newValue, Set<Notifiable> listeners, StateRecorder recorder) throws Impossible {
        if (this._complete) {
            return;
        }
        if (this._value == oldValue && oldValue != newValue) {
            if (recorder != null) {
                recorder.record(() -> {
                    this._value = oldValue;
                });
            }
            this._value = newValue;
        }
        if (!Unify.isComplete(this._value)) {
            Object object = this._value;
            if (object instanceof Referable) {
                Referable referable = (Referable)object;
                referable.addBacklink(this, recorder);
                return;
            }
            throw new RuntimeException("An incomplete value that is referred to was not referable. Strange");
        }
        if (recorder != null) {
            recorder.record(() -> {
                this._complete = false;
            });
        }
        this._complete = true;
        if (Unify.isBound(this._value)) {
            if (recorder != null) {
                recorder.record(() -> {
                    this._bound = false;
                });
            }
            this._bound = true;
        }
        this._referer.possiblyCompleted(listeners, recorder);
    }

    public Referer getReferer() {
        return this._referer;
    }

    public boolean isBound() {
        return this._bound;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public Object getValue() {
        return this._value;
    }
}

