/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;

public class BottomClassLoader
extends URLClassLoader
implements Serializable {
    public static final Logger LOGGER = Logger.getLogger(BottomClassLoader.class);
    public static final String CLASSPATH_PROP_NAME = "de.renew.classPath";

    public BottomClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public BottomClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        PluginProperties props = PluginProperties.getUserProperties();
        String classpath = props.getProperty(CLASSPATH_PROP_NAME, props.getProperty("user.dir"));
        if (classpath != null) {
            String[] parts = classpath.split(new String(new char[]{File.pathSeparatorChar}));
            StringBuffer effectiveClasspath = new StringBuffer();
            boolean firstEffectiveClasspath = true;
            for (int x = 0; x < parts.length; ++x) {
                try {
                    URL url = new URL(parts[x]);
                    this.addURL(url);
                    if (firstEffectiveClasspath) {
                        firstEffectiveClasspath = false;
                    } else {
                        effectiveClasspath.append(File.pathSeparatorChar);
                    }
                    effectiveClasspath.append(url.toString());
                    continue;
                }
                catch (MalformedURLException e1) {
                    File path = new File(parts[x]);
                    if (path.exists()) {
                        try {
                            this.addURL(path.toURI().toURL());
                            if (firstEffectiveClasspath) {
                                firstEffectiveClasspath = false;
                            } else {
                                effectiveClasspath.append(File.pathSeparatorChar);
                            }
                            effectiveClasspath.append(path.toString());
                        }
                        catch (MalformedURLException e2) {
                            LOGGER.warn((Object)(String.valueOf(this) + ": could not add " + parts[x] + " to simulation classpath."));
                            LOGGER.debug((Object)("Malformed URL: " + parts[x]), (Throwable)e1);
                            LOGGER.debug((Object)("Malformed URL for file: " + String.valueOf(path)), (Throwable)e2);
                        }
                        continue;
                    }
                    LOGGER.warn((Object)(String.valueOf(this) + ": could not add " + parts[x] + " to simulation classpath."));
                    LOGGER.debug((Object)("Malformed URL: " + parts[x]), (Throwable)e1);
                    LOGGER.debug((Object)("Nonexisting file: " + String.valueOf(path)));
                }
            }
            props.setProperty(CLASSPATH_PROP_NAME, effectiveClasspath.toString());
        } else {
            LOGGER.warn((Object)(String.valueOf(this) + ": no classpath configured for simulations."));
        }
    }

    @Override
    public void addURL(URL url) {
        LOGGER.debug((Object)(String.valueOf(this) + " adding URL " + String.valueOf(url)));
        super.addURL(url);
    }
}

