/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class DependencyCheckList<O> {
    private List<DependencyElement<O>> _fulfilledElements = new Vector<DependencyElement<O>>();
    private Collection<String> _provided = new HashSet<String>();
    private Collection<DependencyElement<O>> _unfulfilledElements = new Vector<DependencyElement<O>>();

    public synchronized void addElement(DependencyElement<O> el) {
        if (el._requirements.isEmpty()) {
            this._fulfilledElements.add(0, el);
            this._provided.addAll(el._provisions);
            this.checkUnfulfilled();
            return;
        }
        int limit = this._fulfilledElements.size();
        Vector<String> requirements = new Vector<String>(el._requirements);
        for (int i = 0; i < limit; ++i) {
            DependencyElement<O> dl = this._fulfilledElements.get(i);
            requirements.removeAll(dl._provisions);
            if (!requirements.isEmpty()) continue;
            this._fulfilledElements.add(i + 1, el);
            this._provided.addAll(el._provisions);
            this.checkUnfulfilled();
            return;
        }
        this._unfulfilledElements.add(el);
    }

    public synchronized void removeElement(O toRemove) throws DependencyNotFulfilledException {
        Vector<DependencyElement<O>> after = new Vector<DependencyElement<O>>();
        for (int i = this._fulfilledElements.size() - 1; i >= 0; --i) {
            DependencyElement<O> de = this._fulfilledElements.get(i);
            if (toRemove.equals(de._contained)) {
                if (!after.isEmpty()) {
                    Vector<DependencyElement> hurt = new Vector<DependencyElement>();
                    for (DependencyElement dependencyElement : after) {
                        if (!dependencyElement.requiresAny(de._provisions)) continue;
                        hurt.add(dependencyElement);
                    }
                    if (!hurt.isEmpty()) {
                        throw new DependencyNotFulfilledException("cannot remove " + String.valueOf(toRemove) + ": other elements are dependent on it.", hurt);
                    }
                }
                this._fulfilledElements.remove(i);
                this._provided.removeAll(de._provisions);
                return;
            }
            after.add(de);
        }
    }

    public Collection<DependencyElement<O>> getDependentPlugins(O plugin) {
        Vector<DependencyElement<O>> after = new Vector<DependencyElement<O>>();
        for (int i = this._fulfilledElements.size() - 1; i >= 0; --i) {
            DependencyElement<O> de = this._fulfilledElements.get(i);
            if (plugin.equals(de._contained) && !after.isEmpty()) {
                Vector<DependencyElement<O>> hurt = new Vector<DependencyElement<O>>();
                for (DependencyElement dependencyElement : after) {
                    if (!dependencyElement.requiresAny(de._provisions)) continue;
                    hurt.add(dependencyElement);
                }
                return hurt;
            }
            after.add(de);
        }
        return new Vector<DependencyElement<O>>();
    }

    public synchronized Collection<DependencyElement<O>> removeElementWithDependencies(O toRemove) {
        DependencyElement<O> elementToRemove = null;
        HashSet<String> guaranteedProvisions = new HashSet<String>();
        HashSet<String> retractedProvisions = new HashSet<String>();
        Vector<DependencyElement<O>> elementsToRetract = new Vector<DependencyElement<O>>(this._fulfilledElements.size());
        int i = 0;
        while (elementToRemove == null && i < this._fulfilledElements.size()) {
            DependencyElement<O> de = this._fulfilledElements.get(i);
            if (toRemove.equals(de._contained)) {
                elementToRemove = de;
                continue;
            }
            guaranteedProvisions.addAll(de._provisions);
            ++i;
        }
        if (elementToRemove != null) {
            boolean loop;
            int again = i + 1;
            do {
                elementsToRetract.clear();
                retractedProvisions.clear();
                retractedProvisions.addAll(elementToRemove._provisions);
                retractedProvisions.removeAll(guaranteedProvisions);
                boolean bl = loop = !retractedProvisions.isEmpty();
                if (!loop) break;
                for (i = again; loop && i < this._fulfilledElements.size(); ++i) {
                    DependencyElement<O> hurtCand = this._fulfilledElements.get(i);
                    if (hurtCand.requiresAny(retractedProvisions)) {
                        elementsToRetract.add(hurtCand);
                        retractedProvisions.addAll(hurtCand._provisions);
                        retractedProvisions.removeAll(guaranteedProvisions);
                        continue;
                    }
                    guaranteedProvisions.addAll(hurtCand._provisions);
                    loop = !retractedProvisions.removeAll(hurtCand._provisions);
                }
            } while (!loop);
            this._fulfilledElements.remove(elementToRemove);
            this._fulfilledElements.removeAll(elementsToRetract);
            this._unfulfilledElements.addAll(elementsToRetract);
        }
        return elementsToRetract;
    }

    public Collection<String> getFulfilledProvisions() {
        return this._provided;
    }

    public synchronized List<DependencyElement<O>> getFulfilled() {
        return this._fulfilledElements;
    }

    public synchronized Collection<DependencyElement<O>> getUnfulfilled() {
        return this._unfulfilledElements;
    }

    public synchronized List<O> getFulfilledObjects() {
        Vector result = new Vector();
        for (DependencyElement<O> el : this.getFulfilled()) {
            result.add(el._contained);
        }
        return result;
    }

    protected synchronized void checkUnfulfilled() {
        DependencyElement<O> toAdd = null;
        Iterator<DependencyElement<O>> it = this._unfulfilledElements.iterator();
        while (it.hasNext()) {
            DependencyElement<O> el = it.next();
            if (!this.dependencyFulfilled(el)) continue;
            toAdd = el;
            it.remove();
            break;
        }
        if (toAdd != null) {
            this.addElement(toAdd);
        }
    }

    public synchronized boolean dependencyFulfilled(DependencyElement<?> el) {
        Vector<String> req = new Vector<String>(el._requirements);
        req.removeAll(this._provided);
        return req.isEmpty();
    }

    public static <O> DependencyElement<O> createElement(O o, String[] prov, String[] req) {
        return new DependencyElement<O>(o, Arrays.asList(prov), Arrays.asList(req));
    }

    public static class DependencyElement<O> {
        private O _contained;
        private Set<String> _provisions;
        private Set<String> _requirements;

        public DependencyElement(O contained, Collection<String> prov, Collection<String> req) {
            this._contained = contained;
            this._provisions = new HashSet<String>(prov);
            this._requirements = new HashSet<String>(req);
        }

        public static DependencyElement<PluginProperties> create(PluginProperties props) {
            return new DependencyElement<PluginProperties>(props, props.getProvisions(), props.getRequirements());
        }

        public static DependencyElement<IPlugin> create(IPlugin plugin) {
            return new DependencyElement<IPlugin>(plugin, plugin.getProperties().getProvisions(), plugin.getProperties().getRequirements());
        }

        public boolean requiresAny(Collection<? extends String> c) {
            for (String string : c) {
                if (!this._requirements.contains(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this._contained) + "; providing " + CollectionLister.toString(this._provisions) + "; requiring " + CollectionLister.toString(this._requirements);
        }

        public String toStringExtended(List<String> loadedPluginMainClasses) {
            List<String> missingRequirements = this.getMissingRequirements(loadedPluginMainClasses);
            String nameOfPlugin = this._contained.toString();
            if (this._contained instanceof IPlugin) {
                nameOfPlugin = ((IPlugin)this._contained).getName();
            }
            if (this._contained instanceof PluginProperties) {
                nameOfPlugin = ((PluginProperties)this._contained).getName();
            }
            return nameOfPlugin + "\n ---> providing \n * " + CollectionLister.toString(this._provisions, "\n * ") + ";\n ---> requiring but missing \n * " + CollectionLister.toString(missingRequirements, "\n * ");
        }

        public List<String> getMissingRequirements(List<String> loadedPluginMainClasses) {
            Vector<String> missingRequirements = new Vector<String>();
            if (this._requirements != null) {
                for (String required : this._requirements) {
                    if (loadedPluginMainClasses.contains(required)) continue;
                    missingRequirements.add(required);
                }
            }
            return missingRequirements;
        }

        public String getPluginName() {
            if (this._contained == null) {
                return null;
            }
            if (this._contained instanceof PluginProperties) {
                return ((PluginProperties)this._contained).getName();
            }
            if (this._contained instanceof IPlugin) {
                return ((IPlugin)this._contained).getName();
            }
            return null;
        }

        public Set<String> getProvisions() {
            return this._provisions;
        }
    }
}

