/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.SimplePluginLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class PluginAdapter
implements IPlugin {
    public static final Logger LOGGER;
    @Deprecated(forRemoval=true)
    public static final Logger logger;
    protected PluginProperties _properties;

    public PluginAdapter(URL location) throws PluginException {
        this(PluginAdapter.loadPluginPropertiesFromURL(location));
    }

    public PluginAdapter(PluginProperties props) {
        this._properties = props;
    }

    protected static PluginProperties loadPluginPropertiesFromURL(URL location) throws PluginException {
        PluginProperties pluginProps = new PluginProperties(location);
        try {
            InputStream stream = SimplePluginLoader.PluginConfigFinder.getConfigInputStream(location);
            pluginProps.load(stream);
            stream.close();
        }
        catch (MalformedURLException e) {
            throw new PluginException("PluginAdapter constructor: trying to find properties", e);
        }
        catch (IOException e) {
            throw new PluginException("PluginAdapter constructor: trying to read properties", e);
        }
        return pluginProps;
    }

    @Override
    public String getName() {
        return this.getProperties().getProperty("name");
    }

    @Override
    public String getAlias() {
        return this.getProperties().getProperty("alias");
    }

    public String toString() {
        return "plugin " + this.getName();
    }

    @Override
    public void init() {
        LOGGER.debug((Object)(String.valueOf(this) + ": (default) init method called."));
    }

    @Override
    public boolean cleanup() {
        LOGGER.debug((Object)(String.valueOf(this) + ": (default) cleanup method called."));
        return true;
    }

    @Override
    public boolean canShutDown() {
        LOGGER.debug((Object)(String.valueOf(this) + ": (default) canShutDown method called."));
        return true;
    }

    @Override
    public PluginProperties getProperties() {
        return this._properties;
    }

    protected void registerExitBlock() {
        LOGGER.debug((Object)(String.valueOf(this) + " blocking exit."));
        PluginManager.getInstance().blockExit(this);
    }

    protected void registerExitOk() {
        LOGGER.debug((Object)(String.valueOf(this) + " releasing exit block."));
        PluginManager.getInstance().exitOk(this);
    }

    @Override
    public String getLongVersion() {
        Object result = "";
        PluginProperties props = this.getProperties();
        if (props.containsKey("version")) {
            String versionDate;
            String versionText = props.getProperty("versionText");
            if (versionText == null) {
                versionText = "Version: ";
            }
            if ((versionDate = props.getProperty("versionDate")) == null) {
                versionDate = "no date set";
            }
            result = versionText + " " + this.getVersion() + "! Date: " + versionDate;
        }
        return result;
    }

    @Override
    public String getVersion() {
        String result = "";
        PluginProperties props = this.getProperties();
        if (props.containsKey("version")) {
            result = this.getProperties().getProperty("version");
        }
        return result;
    }

    @Override
    public void startUpComplete() {
    }

    @Override
    public void startUpComplete(boolean initialStart) {
        this.startUpComplete();
    }

    static {
        logger = LOGGER = Logger.getLogger(PluginAdapter.class);
    }
}

