/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PropertyHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginProperties
extends Properties {
    public static final String NAME = "name";
    public static final String MAIN_CLASS = "mainClass";
    public static final String REQUIRES = "requires";
    public static final String PROVIDES = "provides";
    public static final String UNKNOWN = "unknown";
    public static final String VERSION = "version";
    public static final String VERSION_TEXT = "versionText";
    public static final String VERSION_DATE = "versionDate";
    protected static PluginProperties _userProperties;
    private URL _sourceURL;
    public static final Logger LOGGER;
    public static final String NULL_VALUE = "<not set>";
    Collection<Object> _knownProperties = new HashSet<Object>();

    public PluginProperties(URL source, InputStream loadFrom) throws IOException {
        this._sourceURL = source;
        this.load(loadFrom);
        this.setKnownProperties();
        this._knownProperties.remove(NAME);
        this._knownProperties.remove(MAIN_CLASS);
        this._knownProperties.remove(REQUIRES);
        this._knownProperties.remove(PROVIDES);
        this._knownProperties.remove(VERSION);
        this._knownProperties.remove(VERSION_TEXT);
        this._knownProperties.remove(VERSION_DATE);
        this.removeNullProperties();
        this.putAll((Map<?, ?>)PluginProperties.getUserProperties());
        this.putAll((Map<?, ?>)System.getProperties());
    }

    public PluginProperties(URL source) {
        super(PluginProperties.getUserProperties());
        this.putAll((Map<?, ?>)System.getProperties());
        this._sourceURL = source;
    }

    protected PluginProperties() {
        this.putAll((Map<?, ?>)System.getProperties());
    }

    private void removeNullProperties() {
        Iterator<Map.Entry<Object, Object>> entries = this.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            if (!NULL_VALUE.equals(entry.getValue())) continue;
            entries.remove();
        }
    }

    public URL getURL() {
        return this._sourceURL;
    }

    public String getMainClass() {
        return this.getProperty(MAIN_CLASS, "");
    }

    public String getName() {
        return this.getProperty(NAME, UNKNOWN);
    }

    public String getVersion() {
        return this.getProperty(VERSION, UNKNOWN);
    }

    public String getVersionDate() {
        return this.getProperty(VERSION_DATE, UNKNOWN);
    }

    public String getVersionText() {
        return this.getProperty(VERSION_TEXT, UNKNOWN);
    }

    public Collection<String> getProvisions() {
        String result = this.getProperty(PROVIDES, "");
        return PropertyHelper.parseListString(result);
    }

    public Collection<String> getRequirements() {
        String result = this.getProperty(REQUIRES, "");
        return PropertyHelper.parseListString(result);
    }

    public String[] getKnownProperties() {
        return this._knownProperties.toArray(new String[this._knownProperties.size()]);
    }

    public boolean isKnownProperty(String name) {
        return this._knownProperties.contains(name);
    }

    @Override
    public synchronized String toString() {
        return "properties of Plugin " + this.getName();
    }

    public String toExtString() {
        String result = "properties of Plugin " + this.getName() + ":\n";
        result = result + "loaded from URL " + String.valueOf(this.getURL()) + "\n";
        result = result + "main class is " + this.getMainClass() + "\n";
        result = result + "provides " + CollectionLister.toString(this.getProvisions()) + "\n";
        result = result + "requires " + CollectionLister.toString(this.getRequirements());
        return result;
    }

    public static PluginProperties getUserProperties() {
        if (_userProperties == null) {
            String errorDescription;
            PluginProperties props = new PluginProperties();
            URL url = null;
            try {
                url = PluginManager.getLoaderLocation();
                String base = url.toExternalForm();
                base = base.substring(0, base.lastIndexOf("/"));
                url = new URL(base + "/config/renew.properties");
            }
            catch (Exception e) {
                errorDescription = e.toString();
                LOGGER.warn((Object)("Could not determine installation properties file name: " + errorDescription));
                LOGGER.debug((Object)errorDescription, (Throwable)e);
                url = null;
            }
            PluginProperties.fillProperties(url, "installation", props);
            try {
                String homeDir = System.getProperty("user.home");
                url = new File(homeDir + File.separator + ".renew.properties").toURI().toURL();
            }
            catch (Exception e) {
                errorDescription = e.toString();
                LOGGER.warn((Object)("Could not determine user properties file name: " + errorDescription));
                LOGGER.debug((Object)errorDescription, (Throwable)e);
                url = null;
            }
            PluginProperties.fillProperties(url, "user", props);
            props.putAll((Map<?, ?>)System.getProperties());
            _userProperties = props;
        }
        return _userProperties;
    }

    private static boolean fillProperties(URL url, String kind, PluginProperties props) {
        if (url == null) {
            return false;
        }
        try {
            InputStream stream = url.openStream();
            LOGGER.info((Object)("Reading " + kind + " properties from " + url.toExternalForm()));
            props.load(stream);
            props._sourceURL = url;
            return true;
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)("No " + kind + " properties: " + e.getMessage()));
        }
        catch (IOException e) {
            String errorDescription = e.toString();
            LOGGER.warn((Object)("Could not read " + kind + " properties " + url.toExternalForm() + ": " + errorDescription));
            LOGGER.debug((Object)errorDescription, (Throwable)e);
        }
        return false;
    }

    public boolean getBoolProperty(String property) {
        return PropertyHelper.getBoolProperty(this, property);
    }

    public boolean getBoolProperty(String property, boolean def) {
        return PropertyHelper.getBoolProperty(this, property, def);
    }

    public int getIntProperty(String property, int def) {
        return PropertyHelper.getIntProperty(this, property, def);
    }

    public int getIntProperty(String property) {
        return PropertyHelper.getIntProperty(this, property);
    }

    public List<String> getListProperty(String propName) {
        return PropertyHelper.getListProperty(this, propName);
    }

    public String getFilteredProperty(String filter) {
        String key;
        Enumeration<Object> en = this.keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            if (!key.equals(filter)) continue;
            return (String)this.get(key);
        }
        en = this.keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            LOGGER.debug((Object)("PluginProperties@getFilteredProperty key: " + key + " filter: " + filter + " " + key.endsWith(filter)));
            if (!key.endsWith(filter)) continue;
            return (String)this.get(key);
        }
        return "";
    }

    public Collection<String> getUnsetProperties() {
        String[] props = this.getKnownProperties();
        HashSet<String> unsetProperties = new HashSet<String>();
        for (String prop : props) {
            LOGGER.debug((Object)("PluginProperies@getUnsetProperties: checking for null: " + prop));
            if (this.get(prop) != null) continue;
            unsetProperties.add(prop);
        }
        return unsetProperties;
    }

    public void setKnownProperties() {
        this._knownProperties.addAll(this.keySet());
    }

    public Collection<String> getKeys() {
        Enumeration<Object> tmp = this.keys();
        Vector<String> coll = new Vector<String>();
        while (tmp.hasMoreElements()) {
            coll.add((String)tmp.nextElement());
        }
        return coll;
    }

    static {
        LOGGER = Logger.getLogger(PluginProperties.class);
    }
}

