# AppleUI

## User Guide

_AppleUI_ provides rudimentary support of the MacOS X user interface to the plugin system. 

### Features

- Use Apple "quit" events (like Command-Q) to initiate a clean shutdown of the plugin system instead of killing the process

### Example Usage

1. Open Renew in a MacOS environment.
2. Close Renew by shortcut Command-Q.

### Provided Commands

None.

### Installation

Install _AppleUI_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew if it is running in a MacOS environment.

### Dependencies

This plugin depends on the following plugins and external libraries:

- `Gui`: Not necessary, but its functionality will be slightly enhanced by _AppleUI_ (soft dependency)
- `log4j`: Logging framework

### Configuration

During the initialization of _AppleUI_, no properties are read that could be configured.

## Developer Guide

### Core Classes

- `AppleUI`: Creates a AppleUI with given PluginProperties and connects to the eawt application object.
- `AppleUIListener`: Handles Apple-specific application events.
- `GuiDependencyListener`: Connects to the "Renew Gui" plugin if available.

### How to Extend

_AppleUI_ exposes one Interface, `AboutDisplayer`. It is used to hide gui details from the AppleUI plugin.

### Additional Information

None.