# ImageNetDiff

## User Guide

_ImageNetDiff_ can be used to create png/esp-files of selected drawings.

### Features

- Create png-files of selected drawings and store them in a temp folder.
- Create esp-files of selected drawing and store them in a temp folder.
- Create a png/esp difference image of both and store them in a temp folder. 

### Example Usage

1. Start the diff using Tools -> Net Diff -> Simple PNG Diff
2. In the openend file browser select the first net you want to have as part of the diff
3. Confirm your choice
4. Select a second net in the next opened file browser
5. Confirm your choice again
6. The files are now in your temp folder and a window showing the diff opens

Alternatively, use the provided commands to create and store the images.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- `epsdiff file1 [file2]` - command produces EPS files of drawings in temp folder. If only one argument is given, diff assumes diff against svn base file (in <filepath>/.svn/text-base/<filename>.svn-base).
- `diff file1 [file2]` - command produces PNG files of drawings in temp folder. If only one argument is given, diff assumes diff against svn base file (in <filepath>/.svn/text-base/<filename>.svn-base).

### Installation

Install _ImageNetDiff_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `ch.ifa.draw` 
- `de.renew.export`

### Configuration

During the initialization of _ImageNetDiff_, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.imagenetdiff.background`|`boolean`|Set to true to use old backround style.|`false`

## Developer Guide

### Core Classes

- `PNGDiffCommand`: Implementation of the PNGDiffCommand (`diff`) command.
- `EPSDiffCommand`: Implementation of the EPSDiffCommand (`epsdiff`) command.
- `ImageNetDiffPlugin`: Extends `PluginAdapter` to manage startup and shutdown.
- `AbstractDiffCommand`: Both EPSDiffCommand and ImageNetDiffPlugin extend this class as it provides some of the operations needed.

### How to Extend

_ImageNetDiff_ exposes one Interface, `DiffExecutor`. - AbstractDiffCommand implements this execute the diff image. 

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->

To use this plugin properly "ImageMagick" has to be installed on the system.

<!-- License -->
