/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.lola2.commands.CheckAllCommand;
import de.renew.lola2.commands.CheckAllTasksCommand;
import de.renew.lola2.commands.CheckLivenessCommand;
import de.renew.lola2.commands.CheckSelectedPlaceCommand;
import de.renew.lola2.commands.CheckSelectedTransitionCommand;
import de.renew.lola2.commands.CheckVerificationRequestCommand;
import de.renew.lola2.commands.OpenLolaGUICommand;
import de.renew.lola2.io.LolaExportFormat;
import de.renew.lola2.io.LolaImportFormat;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class LolaPlugin
extends PluginAdapter {
    private CommandMenu _menu;
    private LolaExportFormat _lolaExportFormat;
    private LolaImportFormat _lolaImportFormat;
    private static StringBuffer _lolaPath = new StringBuffer();
    private static Logger _logger = Logger.getLogger(LolaPlugin.class);

    public LolaPlugin(URL url) throws PluginException {
        super(url);
    }

    public LolaPlugin(PluginProperties props) {
        super(props);
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }
        current.getExportHolder().removeExportFormat((ExportFormat)this._lolaExportFormat);
        current.getImportHolder().removeImportFormat((ImportFormat)this._lolaImportFormat);
        MenuManager mm = current.getMenuManager();
        if (mm != null && this._menu != null) {
            mm.unregisterMenu((JMenuItem)this._menu);
        }
        return true;
    }

    public String getAlias() {
        return "lola";
    }

    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        ExportHolder exportHolder = DrawPlugin.getCurrent().getExportHolder();
        this._lolaExportFormat = new LolaExportFormat();
        exportHolder.addExportFormat((ExportFormat)this._lolaExportFormat);
        ImportHolder importHolder = DrawPlugin.getCurrent().getImportHolder();
        this._lolaImportFormat = new LolaImportFormat();
        importHolder.addImportFormat((ImportFormat)this._lolaImportFormat);
        if (current == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola] Plugin Name: " + this._properties.getName()));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola] Plugin Location: " + String.valueOf(this._properties.getURL())));
        }
        String mylocation = this._properties.getURL().getPath();
        try {
            mylocation = URLDecoder.decode(this._properties.getURL().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            _logger.warn((Object)"[Lola] could not decode location of Lola plugin.");
        }
        String separator = System.getProperty("file.separator");
        _lolaPath.append(mylocation.substring(0, mylocation.lastIndexOf("/")).replace("%20", " "));
        _lolaPath.append(separator + "lib" + separator);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[Lola] computed lib path: " + _lolaPath.toString()));
        }
        MenuManager mm = current.getMenuManager();
        this._menu = new CommandMenu("Lola2 Integration");
        this._menu.add((Command)new OpenLolaGUICommand("Show Lola GUI", _lolaPath.toString()));
        this._menu.add((Command)new CheckAllTasksCommand("Check all verification tasks", _lolaPath.toString()));
        this._menu.add((Command)new CheckVerificationRequestCommand("Check selected request", _lolaPath.toString()));
        this._menu.add((Command)new CheckSelectedTransitionCommand("Check selected Transitions", _lolaPath.toString()));
        this._menu.add((Command)new CheckSelectedPlaceCommand("Check selected Places", _lolaPath.toString()));
        this._menu.add((Command)new CheckAllCommand("Check all places and transitions", _lolaPath.toString()));
        this._menu.add((Command)new CheckLivenessCommand("Check liveness", _lolaPath.toString()));
        this._menu.add((Command)new VersionInfoCommand((IPlugin)this));
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.lola");
        mm.registerMenu("Tools", (JMenuItem)this._menu);
    }

    public static String getLolaPath() {
        return _lolaPath.toString();
    }

    public static LolaPlugin getCurrent() {
        for (Object plugin : PluginManager.getInstance().getPluginsProviding("de.renew.lola")) {
            if (!(plugin instanceof LolaPlugin)) continue;
            return (LolaPlugin)((Object)plugin);
        }
        return null;
    }
}

