/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.commands.CheckAllCommand;
import java.io.File;
import org.apache.log4j.Logger;

public class CheckLivenessCommand
extends Command {
    private String _lolaPath;
    private static Logger _logger = Logger.getLogger(CheckLivenessCommand.class);

    public CheckLivenessCommand(String name, String path) {
        super(name);
        this._lolaPath = path;
    }

    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing)app.drawing();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(this._lolaPath);
        File netFile = new LolaFileCreator().writeTemporaryLolaFile(drawing);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + netFile.getPath()));
        }
        IndirectLolaResult result = analyzer.checkNetLiveness(netFile, true);
        switch (result.getStatus()) {
            case YES: {
                _logger.info((Object)"YES, net is live.");
                break;
            }
            case NO: {
                _logger.info((Object)"NO, net is not live.");
                break;
            }
            default: {
                _logger.info((Object)("Unspecified result for liveness: " + String.valueOf((Object)result.getStatus())));
            }
        }
    }
}

