/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.impl;

import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import de.renew.navigator.vc.VersionControlAggregator;
import java.io.File;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VersionControlAggregatorImpl
implements VersionControlAggregator {
    public static final Logger LOGGER = Logger.getLogger(VersionControlAggregatorImpl.class);
    private final LinkedList<VersionControl> _versionControls = new LinkedList();

    @Override
    public void addVersionControl(VersionControl vcs) {
        this._versionControls.add(vcs);
    }

    @Override
    public boolean removeVersionControl(VersionControl vcs) {
        return this._versionControls.remove(vcs);
    }

    @Override
    public boolean controls(File workingDir) {
        for (VersionControl versionControl : this._versionControls) {
            if (!versionControl.controls(workingDir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean diff(File file) {
        Repository r = this.findRepository(file);
        if (r == null) {
            this.warnNotInARepository(file);
            return false;
        }
        return r.getVersionControl().diff(file);
    }

    @Override
    public boolean log(File file) {
        Repository r = this.findRepository(file);
        if (r == null) {
            this.warnNotInARepository(file);
            return false;
        }
        return r.getVersionControl().log(file);
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (VersionControl versionControl : this._versionControls) {
            if (!isFirst) {
                builder.append(',');
            } else {
                isFirst = false;
            }
            builder.append(versionControl.getName());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Repository findRepository(File fileInRepository) {
        for (VersionControl accessor : this._versionControls) {
            if (!accessor.controls(fileInRepository)) continue;
            return accessor.findRepository(fileInRepository);
        }
        this.warnNotInARepository(fileInRepository);
        return null;
    }

    private void warnNotInARepository(File file) {
        LOGGER.warn((Object)("The file " + file.getAbsolutePath() + " seems not to be in a repository known to " + this.getName()));
    }
}

