/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import de.renew.refactoring.inline.InlineController;
import de.renew.refactoring.inline.InlineListener;
import de.renew.refactoring.inline.InlineStep;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class InlineControllerWithListener
implements InlineController {
    private static final Logger LOGGER = Logger.getLogger(InlineControllerWithListener.class);
    private Set<InlineListener> _listeners = new HashSet<InlineListener>();

    @Override
    public abstract InlineStep nextStep();

    @Override
    public void addListener(InlineListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(InlineListener listener) {
        this._listeners.remove(listener);
    }

    protected Set<InlineListener> getListeners() {
        return this._listeners;
    }

    protected void informListenersFinished() {
        for (InlineListener listener : this.getListeners()) {
            listener.inlineFinished();
        }
    }
}

