/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.LinkParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexLinkParser
implements LinkParser {
    @Override
    public boolean isValidChannelName(String name) {
        return Patterns.NAME_PATTERN.matcher(name).matches();
    }

    @Override
    public boolean containsUplink(String string) {
        return Patterns.UPLINK_PATTERN.matcher(string).find();
    }

    @Override
    public boolean containsDownlink(String string) {
        return Patterns.DOWNLINK_PATTERN.matcher(string).find();
    }

    @Override
    public StringMatch findUplink(String string) {
        Matcher matcher = Patterns.UPLINK_PATTERN.matcher(string);
        if (matcher.find()) {
            return new StringMatch(string.substring(matcher.start(), matcher.end()), matcher.start(), matcher.end());
        }
        return null;
    }

    @Override
    public StringMatch findUplink(String string, String channel, int parameterCount) {
        return null;
    }

    @Override
    public StringMatch findChannelName(String string) {
        assert (this.containsUplink(string) || this.containsDownlink(string));
        int nameStart = string.indexOf(58) + 1;
        int nameEnd = string.indexOf(40);
        return new StringMatch(string.substring(nameStart, nameEnd).trim(), nameStart, nameEnd);
    }

    @Override
    public int findParameterCount(String string) {
        int closingPar;
        assert (this.containsUplink(string) || this.containsDownlink(string));
        int openingPar = string.indexOf(40);
        String betweenPars = string.substring(openingPar + 1, closingPar = string.indexOf(41));
        if (betweenPars.trim().isEmpty()) {
            return 0;
        }
        int bracketLevel = 0;
        int parameterCount = 1;
        block5: for (int i = 0; i < betweenPars.length(); ++i) {
            switch (betweenPars.charAt(i)) {
                case '[': {
                    ++bracketLevel;
                    continue block5;
                }
                case ']': {
                    --bracketLevel;
                    continue block5;
                }
                case ',': {
                    if (bracketLevel != 0) continue block5;
                    ++parameterCount;
                    continue block5;
                }
            }
        }
        return parameterCount;
    }

    @Override
    public boolean isDownlinkToThis(String link) {
        return Patterns.DOWNLINK_TO_THIS_PATTERN.matcher(link).matches();
    }

    @Override
    public List<StringMatch> findDownlinks(String string) {
        return null;
    }

    @Override
    public List<StringMatch> findDownlinks(String string, String channel, int parameterCount) {
        Pattern downlinkPattern = this.downlinkPatternForChannel(channel, parameterCount);
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        Matcher downlinkMatcher = downlinkPattern.matcher(string);
        while (downlinkMatcher.find()) {
            int downlinkStart = downlinkMatcher.start();
            int downlinkEnd = downlinkMatcher.end();
            String downlink = string.substring(downlinkStart, downlinkEnd);
            StringMatch match = new StringMatch(downlink, downlinkStart, downlinkEnd);
            matches.add(match);
        }
        return matches;
    }

    protected Pattern downlinkPatternForChannel(String channel, int parameterCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(Patterns.DOWNLINK_BEFORE_CHANNEL_NAME);
        sb.append(Patterns.addWhitespace(channel));
        sb.append(Patterns.OPENING_PAR);
        if (parameterCount > 0) {
            sb.append(Patterns.PARAM);
        }
        if (parameterCount > 1) {
            sb.append("(," + Patterns.PARAM + ")");
            sb.append("{" + (parameterCount - 1) + "}");
        }
        sb.append(Patterns.CLOSING_PAR);
        return Pattern.compile(sb.toString());
    }

    final class Patterns {
        static final String WHITESPACE = "\\s*";
        static final String PARENTHESES = "\\(.*\\)";
        static final Pattern NAME_PATTERN = Pattern.compile(Patterns.addWhitespace("\\w[\\w\\d]*"));
        static final Pattern UPLINK_PATTERN = Pattern.compile("(^\\s*|;\\s*):" + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
        static final Pattern DOWNLINK_PATTERN = Pattern.compile(String.valueOf(NAME_PATTERN) + Patterns.addWhitespace(":") + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
        static final Pattern DOWNLINK_TO_THIS_PATTERN = Pattern.compile(Patterns.addWhitespace("this") + Patterns.addWhitespace(":") + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
        static final String DOWNLINK_BEFORE_CHANNEL_NAME = Patterns.addWhitespace(NAME_PATTERN) + ":";
        static final String OPENING_PAR = Patterns.addWhitespace("\\(");
        static final String CLOSING_PAR = Patterns.addWhitespace("\\)");
        static final String PARAM = Patterns.addWhitespace("(([\\w]+[\\w\\d\\s]*)|(\\[.*\\]))");

        Patterns() {
        }

        static final String addWhitespace(String string) {
            return WHITESPACE + string + WHITESPACE;
        }

        static final String addWhitespace(Pattern pattern) {
            return WHITESPACE + String.valueOf(pattern) + WHITESPACE;
        }
    }
}

