/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse.name;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.name.NameFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RegexNameFinder
implements NameFinder {
    private static final Logger LOGGER = Logger.getLogger(RegexNameFinder.class);
    private final String _name;
    private final Pattern _namePattern;

    public RegexNameFinder(String name) {
        this(name, null);
    }

    public RegexNameFinder(String name, String exclude) {
        this(name, exclude, exclude);
    }

    public RegexNameFinder(String name, String excludeBefore, String excludeAfter) {
        this._name = name;
        this._namePattern = Pattern.compile("(^|[^\\w" + excludeBefore + "])" + name + "($|[^\\w" + excludeAfter + "])");
    }

    @Override
    public boolean find(String input) {
        return this._namePattern.matcher(input).find();
    }

    @Override
    public List<StringMatch> listOfMatches(String input) {
        Matcher matcher = this._namePattern.matcher(input);
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        while (matcher.find()) {
            String matchedString = input.substring(matcher.start(), matcher.end());
            int nameStart = matcher.start() + matchedString.indexOf(this._name);
            int nameEnd = nameStart + this._name.length();
            String nameString = input.substring(nameStart, nameEnd);
            matches.add(new StringMatch(nameString, nameStart, nameEnd));
        }
        return matches;
    }
}

