/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.search.DrawingSearcher;
import de.renew.refactoring.search.range.DrawingSearchRange;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class RenameChannelReferencingLinkFinder
extends DrawingSearcher<LinkMatch> {
    private static final Logger LOGGER = Logger.getLogger(RenameChannelReferencingLinkFinder.class);
    private final LinkParser _parser;
    private final String _channel;
    private final int _parameterCount;

    RenameChannelReferencingLinkFinder(LinkParser parser, String channel, int parameterCount, DrawingSearchRange searchRange) {
        super(searchRange);
        this._parser = parser;
        this._channel = channel;
        this._parameterCount = parameterCount;
    }

    @Override
    public List<LinkMatch> searchDrawing(Drawing drawing) {
        ArrayList<LinkMatch> matches = new ArrayList<LinkMatch>();
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = figures.nextFigure();
            if (!(figure instanceof CPNTextFigure) || figure instanceof DeclarationFigure) continue;
            CPNTextFigure textFigure = (CPNTextFigure)figure;
            UplinkMatch uplink = this.findUplink(textFigure, drawing);
            if (uplink != null) {
                matches.add(uplink);
            }
            matches.addAll(this.findDownlinks(textFigure, drawing));
        }
        LOGGER.debug((Object)("Found " + matches.size() + " referencing links in drawing " + drawing.getName()));
        return matches;
    }

    private UplinkMatch findUplink(CPNTextFigure textFigure, Drawing drawing) {
        StringMatch uplinkMatch = this._parser.findUplink(textFigure.getText(), this._channel, this._parameterCount);
        if (uplinkMatch != null) {
            StringMatch channelNameMatch = this._parser.findChannelName(uplinkMatch.match());
            return new UplinkMatch(drawing, textFigure, uplinkMatch, channelNameMatch, this._parameterCount);
        }
        return null;
    }

    private List<DownlinkMatch> findDownlinks(CPNTextFigure textFigure, Drawing drawing) {
        ArrayList<DownlinkMatch> matches = new ArrayList<DownlinkMatch>();
        List<StringMatch> downlinks = this._parser.findDownlinks(textFigure.getText(), this._channel, this._parameterCount);
        for (StringMatch downlinkMatch : downlinks) {
            StringMatch channelNameMatch = this._parser.findChannelName(downlinkMatch.match());
            DownlinkMatch match = new DownlinkMatch(drawing, textFigure, downlinkMatch, channelNameMatch, this._parameterCount);
            matches.add(match);
        }
        return matches;
    }
}

