/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search.range;

import de.renew.refactoring.search.range.FileSearchRange;
import de.renew.refactoring.search.range.NetpathFiles;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class NetpathFilesSearchRange
implements FileSearchRange {
    private static final Logger LOGGER = Logger.getLogger(NetpathFilesSearchRange.class);
    private final int _numberOfFiles;
    private final Iterator<File> _files;

    public NetpathFilesSearchRange(String extension) {
        this(Collections.singletonList(extension));
    }

    public NetpathFilesSearchRange(List<String> extensions) {
        List<File> files = NetpathFiles.files(extensions, null);
        this._numberOfFiles = files.size();
        this._files = files.iterator();
    }

    @Override
    public String description() {
        return "Netpath files";
    }

    @Override
    public int numberOfFiles() {
        return this._numberOfFiles;
    }

    @Override
    public Iterator<File> files() {
        return this._files;
    }
}

