/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.util;

public final class ProgressCalculator {
    private ProgressCalculator() {
    }

    public static int calculateProgress(int done, int all) {
        if (all == 0) {
            return 100;
        }
        return ProgressCalculator.sanitizeProgress(100.0 * (double)done / (double)all);
    }

    public static int combinedProgress(int firstOperationProgress, int firstOperationItems, int secondOperationProgress, int secondOperationItems) {
        if (firstOperationItems + secondOperationItems == 0) {
            return 100;
        }
        return ProgressCalculator.sanitizeProgress((firstOperationItems * firstOperationProgress + secondOperationItems * secondOperationProgress) / (firstOperationItems + secondOperationItems));
    }

    private static int sanitizeProgress(double progress) {
        return ProgressCalculator.sanitizeProgress((int)Math.round(progress));
    }

    private static int sanitizeProgress(int progress) {
        if (progress < 0) {
            return 0;
        }
        if (progress > 100) {
            return 100;
        }
        return progress;
    }
}

