/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public abstract class TableSelectButton
extends JButton {
    private static final long serialVersionUID = -6549952914848675014L;
    private static final Logger LOGGER = Logger.getLogger(TableSelectButton.class);
    private final JTable _table;
    private final int _col;

    public TableSelectButton(String title, JTable table, int column) {
        super(title);
        this._table = table;
        this._col = column;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row = 0; row < TableSelectButton.this._table.getRowCount(); ++row) {
                    TableSelectButton.this._table.setValueAt(TableSelectButton.this.selectRow(TableSelectButton.this._table, row), row, TableSelectButton.this._col);
                }
            }
        });
    }

    public abstract boolean selectRow(JTable var1, int var2);

    public static TableSelectButton selectAllButton(String title, JTable table, int column) {
        return new TableSelectButton(title, table, column){
            private static final long serialVersionUID = -1041670163206301939L;

            @Override
            public boolean selectRow(JTable table, int row) {
                return true;
            }
        };
    }

    public static TableSelectButton selectNoneButton(String title, JTable table, int column) {
        return new TableSelectButton(title, table, column){
            private static final long serialVersionUID = -8167772826900151285L;

            @Override
            public boolean selectRow(JTable table, int row) {
                return false;
            }
        };
    }

    public static TableSelectButton selectInstancesButton(String title, final Class<?> clazz, JTable table, int checkboxColumn, final int itemColumn) {
        return new TableSelectButton(title, table, checkboxColumn){
            private static final long serialVersionUID = 4879678711675528458L;

            @Override
            public boolean selectRow(JTable table, int row) {
                Object value = table.getValueAt(row, itemColumn);
                return clazz.isInstance(value);
            }
        };
    }
}

