/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import java.util.Collection;

public class Util {
    public boolean fireTransition(NetInstance instance, String name) {
        Transition transition = this.findTransition(instance, name);
        if (transition == null) {
            return false;
        }
        TransitionInstance transitionInstance = instance.getInstance(transition);
        ExecuteFinder finder = new ExecuteFinder();
        Searcher searcher = new Searcher();
        SimulatorHelper.searchOnce(searcher, finder, transitionInstance, transitionInstance);
        if (finder.isCompleted()) {
            SimulatorPlugin sp = SimulatorPlugin.getCurrent();
            StepIdentifier step = sp.getCurrentEnvironment().getSimulator().nextStepIdentifier();
            finder.execute(step, true);
        }
        return true;
    }

    private Transition findTransition(NetInstance instance, String name) {
        Collection<Transition> transitions = instance.getNet().transitions();
        Transition selection = null;
        for (Transition transition : transitions) {
            if (!transition.getName().equals(name)) continue;
            selection = transition;
            break;
        }
        return selection;
    }

    public NetInstance findInstance(String netInstanceName) {
        return NetInstanceList.getNetInstance(netInstanceName);
    }
}

