/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.Transaction;
import de.renew.database.TransactionStrategy;
import java.util.Hashtable;

public class TransactionSource {
    private static TransactionStrategy strategy = null;
    private static Hashtable<Thread, Transaction> transactions = new Hashtable();
    private static Object hashtableLock = new Object();
    private static Object strategyLock = new Object();

    private TransactionSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStrategy(TransactionStrategy newStrategy) {
        Object object = strategyLock;
        synchronized (object) {
            strategy = newStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(NetAction[] createActions, TokenAction[] addActions, TokenAction[] removeActions, NetAction[] deleteActions) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.perform(createActions, addActions, removeActions, deleteActions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingOpened(String netInstanceID) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.netInstanceDrawingOpened(netInstanceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingClosed(String netInstanceID) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.netInstanceDrawingClosed(netInstanceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulationStateChanged(boolean inited, boolean running) throws Exception {
        Object object = strategyLock;
        synchronized (object) {
            if (strategy != null) {
                strategy.simulationStateChanged(inited, running);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread current = Thread.currentThread();
            if (transactions.containsKey(current)) {
                throw new RuntimeException("Nested transactions not supported.");
            }
            transactions.put(Thread.currentThread(), new Transaction(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transaction get() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread current = Thread.currentThread();
            Transaction transaction = transactions.get(current);
            if (transaction != null) {
                return transaction;
            }
            return new Transaction(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transaction extractCurrentTransaction() {
        Object object = hashtableLock;
        synchronized (object) {
            Thread current = Thread.currentThread();
            Transaction transaction = transactions.get(current);
            if (transaction != null) {
                transactions.remove(current);
            }
            return transaction;
        }
    }

    public static void commit() throws Exception {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.commit();
        }
    }

    public static void rollback() {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.rollback();
        }
    }
}

