/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.simulator.SimulationThreadPool;
import org.apache.log4j.Logger;

public class StepIdentifier
implements Comparable<StepIdentifier> {
    public static Logger logger = Logger.getLogger(StepIdentifier.class);
    private final long simulationRunId;
    private final long[] stepCountVector;

    public StepIdentifier(long simulationRunId, long[] stepCountVector) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.simulationRunId = simulationRunId;
        this.stepCountVector = stepCountVector;
    }

    public long[] getComponents() {
        return this.stepCountVector;
    }

    public long getSimulationRunId() {
        return this.simulationRunId;
    }

    public int hashCode() {
        if (this.stepCountVector.length >= 1) {
            return (int)this.stepCountVector[0];
        }
        return 0;
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof StepIdentifier) {
            StepIdentifier other = (StepIdentifier)otherObj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.stepCountVector.length >= 1) {
            builder.append(this.stepCountVector[0]);
        }
        for (int x = 1; x < this.stepCountVector.length; ++x) {
            builder.append(",");
            builder.append(this.stepCountVector[x]);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int compareTo(StepIdentifier other) throws ClassCastException {
        long[] otherComp = other.getComponents();
        if (this.getSimulationRunId() < other.getSimulationRunId()) {
            return -1;
        }
        if (this.getSimulationRunId() > other.getSimulationRunId()) {
            return 1;
        }
        for (int x = 0; x < otherComp.length; ++x) {
            if (otherComp[x] > this.stepCountVector[x]) {
                return -1;
            }
            if (otherComp[x] >= this.stepCountVector[x]) continue;
            return 1;
        }
        return 0;
    }
}

