/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.IDCounter;
import de.renew.net.IDSource;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class IDRegistry
implements Serializable {
    private static IDRegistry _instance = null;
    private transient Map<Object, Object> table = new HashMap<Object, Object>();

    public static synchronized IDRegistry getInstance() {
        if (_instance == null) {
            _instance = new IDRegistry();
        }
        return _instance;
    }

    private IDCounter register(Object elem) {
        IDCounter counter = (IDCounter)this.table.get(elem);
        if (counter == null) {
            counter = new IDCounter(IDSource.createID());
            this.table.put(elem, counter);
        }
        return counter;
    }

    public synchronized String getID(Object elem) {
        return this.register(elem).getID();
    }

    public synchronized void reserve(Object elem, int n) {
        this.register(elem).reserve(n);
    }

    public synchronized void reserve(Object elem) {
        this.register(elem).reserve();
    }

    public synchronized void unreserve(Object elem) {
        IDCounter counter = this.register(elem);
        counter.unreserve();
        if (counter.isDiscardable()) {
            this.table.remove(elem);
        }
    }

    public synchronized void setAndReserveID(Object elem, String id) {
        IDCounter counter = (IDCounter)this.table.get(elem);
        if (counter == null) {
            counter = new IDCounter(id);
            this.table.put(elem, counter);
        } else if (!counter.getID().equals(id)) {
            throw new RuntimeException("Token already in use.");
        }
        counter.reserve();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this.table = new HashMap<Object, Object>();
        boolean finished = false;
        do {
            Object key;
            if ((key = in.readObject()) == null) {
                finished = true;
                continue;
            }
            Object counter = in.readObject();
            this.table.put(key, counter);
        } while (!finished);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        for (Map.Entry<Object, Object> entry : this.table.entrySet()) {
            Object key = entry.getKey();
            Object counter = entry.getValue();
            out.writeObject(key);
            out.writeObject(counter);
        }
        out.writeObject(null);
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    public static synchronized void reset() {
        _instance = null;
    }

    public static synchronized void save(ObjectOutput out) throws IOException {
        out.writeObject(_instance);
    }

    public static synchronized void load(ObjectInput in) throws IOException, ClassNotFoundException {
        _instance = (IDRegistry)in.readObject();
    }
}

