/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.NetInstantiation;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.IDRegistry;
import de.renew.net.IDSource;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class NetInstanceImpl
implements DelayedFieldOwner,
NetInstance {
    public static Logger logger = Logger.getLogger(NetInstanceImpl.class);
    static final long serialVersionUID = 6136525457931796546L;
    public static boolean useGlobalIDRegistry = false;
    private Hashtable<Object, Object> instanceLookup;
    private Net net;
    private String netID;
    private transient IDRegistry registry;

    protected NetInstanceImpl() {
    }

    protected NetInstanceImpl(Net net) throws Impossible {
        this(net, true);
    }

    protected NetInstanceImpl(Net net, boolean wantInitialTokens) throws Impossible {
        this.initNet(net, wantInitialTokens);
    }

    protected void initNet(Net net, boolean wantInitialTokens) throws Impossible {
        if (net == null) {
            throw new Impossible();
        }
        this.net = net;
        this.netID = IDSource.createID();
        this.registry = useGlobalIDRegistry ? IDRegistry.getInstance() : new IDRegistry();
        this.instanceLookup = new Hashtable();
        for (Place place : net.places()) {
            this.instanceLookup.put(place, place.makeInstance(this, wantInitialTokens));
        }
        for (Transition transition : net.transitions()) {
            this.instanceLookup.put(transition, new TransitionInstance(this, transition));
        }
    }

    public String toString() {
        return String.valueOf(this.net) + "[" + this.netID + "]";
    }

    @Override
    public IDRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public String getID() {
        return this.netID;
    }

    @Override
    public void setID(String id) {
        this.netID = id;
    }

    @Override
    public void earlyConfirmation() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Transaction transaction = TransactionSource.get();
        try {
            transaction.createNet(this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (Place place : this.net.places()) {
            this.getInstance(place).earlyConfirmation();
        }
    }

    @Override
    public void earlyConfirmationTrace(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        for (Place place : this.net.places()) {
            this.getInstance(place).earlyConfirmationTrace(stepIdentifier);
        }
        NetInstanceList.add(this);
    }

    @Override
    public void lateConfirmation(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new NetInstantiation(this), (NetInstance)this);
        for (Place place : this.net.places()) {
            this.getInstance(place).lateConfirmation(stepIdentifier);
        }
        for (Transition transition : this.net.transitions()) {
            this.getInstance(transition).createConfirmation();
        }
    }

    @Override
    public void createConfirmation(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.earlyConfirmation();
        this.earlyConfirmationTrace(stepIdentifier);
        this.lateConfirmation(stepIdentifier);
    }

    @Override
    public Object getInstance(Object netObject) {
        return this.instanceLookup.get(netObject);
    }

    @Override
    public PlaceInstance getInstance(Place place) {
        return (PlaceInstance)this.instanceLookup.get(place);
    }

    @Override
    public TransitionInstance getInstance(Transition transition) {
        return (TransitionInstance)this.instanceLookup.get(transition);
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Collection<UplinkProvider> getUplinkProviders(String channel) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<UplinkProvider> result = new ArrayList<UplinkProvider>();
        for (Transition transition : this.getNet().transitions()) {
            TransitionInstance instance = this.getInstance(transition);
            if (!instance.listensToChannel(channel)) continue;
            result.add(instance);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.delayedWriteObject((Object)this.registry, (DelayedFieldOwner)this);
            rOut.endDomain((Object)this);
        } else {
            out.writeObject(this.registry);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        if (in instanceof RenewObjectInputStream) {
            if (((RenewObjectInputStream)in).isCopiousBehaviour()) {
                String newNetID = IDSource.createID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deserialized NetInstance copy: changed id from " + this.netID + " to " + newNetID + "."));
                }
                this.netID = newNetID;
            }
        } else {
            this.registry = (IDRegistry)in.readObject();
        }
        NetInstanceList.add(this);
    }

    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!(value instanceof IDRegistry)) {
            throw new NotSerializableException("Value of unexpected type given to NetInstanceImpl.reassignField():" + value.getClass().getName() + ".");
        }
        this.registry = (IDRegistry)value;
    }
}

