/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.FIFOPlaceInstance;
import de.renew.net.MultisetPlaceInstance;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenSource;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventListenerSet;
import de.renew.net.event.PlaceEventProducer;
import de.renew.unify.Impossible;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Place
implements Serializable,
PlaceEventProducer {
    static final long serialVersionUID = 5661978821450640374L;
    public static final int MULTISETPLACE = 0;
    public static final int FIFOPLACE = 1;
    NetElementID id;
    String name;
    String comment;
    private boolean trace;
    Set<TokenSource> inscriptions;
    private int placetype = 0;
    private transient PlaceEventListenerSet listeners = new PlaceEventListenerSet();

    public Place(Net net, String name, NetElementID id) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.id = id;
        this.name = name;
        this.trace = true;
        this.inscriptions = new HashSet<TokenSource>();
        net.add(this);
    }

    public NetElementID getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public void setBehaviour(int behaviour) {
        this.placetype = behaviour;
    }

    protected PlaceInstance makeInstance(NetInstance netInstance, boolean wantInitialTokens) throws Impossible {
        SimulatablePlaceInstance instance = null;
        switch (this.placetype) {
            case 0: {
                instance = new MultisetPlaceInstance(netInstance, this, wantInitialTokens);
                break;
            }
            case 1: {
                instance = new FIFOPlaceInstance(netInstance, this, wantInitialTokens);
                break;
            }
            default: {
                throw new RuntimeException("Illegal place behaviour: " + this.placetype);
            }
        }
        return instance;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public String getName() {
        return this.name;
    }

    public void add(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.inscriptions.add(tokenSource);
    }

    public void remove(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.inscriptions.remove(tokenSource);
    }

    public Set<TokenSource> getTokenSources() {
        return this.inscriptions;
    }

    public boolean hasInitialTokens() {
        return this.inscriptions.size() != 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this.listeners = new PlaceEventListenerSet();
    }

    @Override
    public void addPlaceEventListener(PlaceEventListener listener) {
        this.listeners.addPlaceEventListener(listener);
    }

    @Override
    public void removePlaceEventListener(PlaceEventListener listener) {
        this.listeners.removePlaceEventListener(listener);
    }

    public PlaceEventListenerSet getListenerSet() {
        return this.listeners;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }
}

