/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.event;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.net.event.ListenerSetDispatcher;
import de.renew.net.event.NetEventListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListenerSet {
    public static final Logger logger = Logger.getLogger(ListenerSet.class);
    private transient Set<NetEventListener> listeners = new HashSet<NetEventListener>();

    synchronized void include(NetEventListener listener) {
        this.listeners.add(listener);
    }

    synchronized void exclude(NetEventListener listener) {
        this.listeners.remove(listener);
    }

    synchronized void dispatch(final ListenerSetDispatcher dispatcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        NetEventListener[] listenerArray = this.listeners.toArray(new NetEventListener[0]);
        for (int x = 0; x < listenerArray.length; ++x) {
            if (listenerArray[x].wantSynchronousNotification()) {
                try {
                    dispatcher.dispatchTo(listenerArray[x]);
                }
                catch (RuntimeException e) {
                    logger.error((Object)("Error while dispatching net event: " + String.valueOf(e)), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)("Error while dispatching net event: " + String.valueOf(e)), (Throwable)e);
                }
                continue;
            }
            final NetEventListener listener = listenerArray[x];
            SimulatorEventQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                    try {
                        dispatcher.dispatchTo(listener);
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)("Error while dispatching net event: " + String.valueOf(e)), (Throwable)e);
                    }
                    catch (Error e) {
                        logger.error((Object)("Error while dispatching net event: " + String.valueOf(e)), (Throwable)e);
                    }
                }
            });
        }
    }
}

