/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.inscription.ConditionalInscription;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

class ConditionalOccurrence
extends AbstractOccurrence
implements Occurrence,
Binder {
    ConditionalInscription conditionalInscription;
    VariableMapper mapper;
    NetInstance netInstance;
    Variable conditionVariable;
    private Collection<Occurrence> secondaryOccurrences;
    private boolean wantToOccur;

    public ConditionalOccurrence(ConditionalInscription conditionalInscription, VariableMapper mapper, NetInstance netInstance, Transition transition) {
        super(netInstance.getInstance(transition));
        this.conditionalInscription = conditionalInscription;
        this.mapper = mapper;
        this.netInstance = netInstance;
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        this.conditionVariable = new Variable(this.conditionalInscription.conditionExpression.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        Vector<Binder> coll = new Vector<Binder>();
        coll.add(this);
        return coll;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this.conditionVariable)) {
            return 1;
        }
        return 10000;
    }

    @Override
    public void bind(Searcher searcher) {
        Object obj = this.conditionVariable.getValue();
        if (!(obj instanceof Value)) {
            return;
        }
        if (!(obj instanceof Boolean)) {
            return;
        }
        ArrayList<Binder> binders = new ArrayList<Binder>();
        int checkpoint = searcher.recorder.checkpoint();
        try {
            boolean wantToOccur = (Boolean)((Value)obj).value;
            this.secondaryOccurrences = new ArrayList<Occurrence>();
            if (wantToOccur) {
                this.secondaryOccurrences.addAll(this.conditionalInscription.inscription.makeOccurrences(this.mapper, this.netInstance, searcher));
                for (Occurrence occurrence : this.secondaryOccurrences) {
                    binders.addAll(occurrence.makeBinders(searcher));
                }
                searcher.addBinders(binders);
            }
            searcher.removeBinder(this);
            searcher.search();
            searcher.addBinder(this);
            if (wantToOccur) {
                searcher.removeBinders(binders);
                this.secondaryOccurrences = null;
            }
        }
        catch (Impossible impossible) {
            // empty catch block
        }
        searcher.recorder.restore(checkpoint);
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier copier) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        if (this.wantToOccur) {
            for (Occurrence occurrence : this.secondaryOccurrences) {
                executables.addAll(occurrence.makeExecutables(copier));
            }
        }
        return executables;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }
}

