/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadow.ShadowLookupExtension;
import de.renew.shadow.ShadowLookupExtensionFactory;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ShadowLookup {
    private Hashtable<String, Net> netMap = new Hashtable();
    private HashSet<String> namesOfNewlyCompiledNets = new HashSet();
    private Hashtable<ShadowPlace, Place> placeMap = new Hashtable();
    private Hashtable<ShadowTransition, Transition> transitionMap = new Hashtable();
    private Hashtable<String, ShadowLookupExtension> extensions = new Hashtable();

    public void setNet(String name, Net net) {
        this.netMap.put(name, net);
    }

    public Net getNet(String name) {
        return this.netMap.get(name);
    }

    public Enumeration<String> allNetNames() {
        return this.netMap.keys();
    }

    public Iterator<String> allNewlyCompiledNetNames() {
        return this.namesOfNewlyCompiledNets.iterator();
    }

    public void set(ShadowPlace element, Place obj) {
        this.placeMap.put(element, obj);
        this.namesOfNewlyCompiledNets.add(element.getNet().getName());
    }

    public Place get(ShadowPlace element) {
        return this.placeMap.get(element);
    }

    public Enumeration<ShadowPlace> allPlaces() {
        return this.placeMap.keys();
    }

    public void set(ShadowTransition element, Transition obj) {
        this.transitionMap.put(element, obj);
        this.namesOfNewlyCompiledNets.add(element.getNet().getName());
    }

    public Transition get(ShadowTransition element) {
        return this.transitionMap.get(element);
    }

    public Enumeration<ShadowTransition> allTransitions() {
        return this.transitionMap.keys();
    }

    public synchronized ShadowLookupExtension getShadowLookupExtension(ShadowLookupExtensionFactory factory) {
        ShadowLookupExtension extension = this.extensions.get(factory.getCategory());
        if (extension == null) {
            extension = factory.createExtension();
            this.extensions.put(factory.getCategory(), extension);
        }
        return extension;
    }

    public void makeNetsKnown() {
        for (Net net : this.netMap.values()) {
            net.makeKnown();
        }
    }

    public boolean containsNewlyCompiledNets() {
        return !this.namesOfNewlyCompiledNets.isEmpty();
    }
}

