/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unifiable;
import de.renew.unify.Unknown;
import java.util.Set;

public final class Calculator
implements Unifiable,
Referable,
Referer {
    private BacklinkSet _backlinkSet;
    private final Reference _reference;
    private final RecorderChecker _recorderChecker;
    private final Class<?> _type;

    Calculator(Class<?> type, Object object, StateRecorder recorder) {
        this._recorderChecker = new RecorderChecker(recorder);
        this._reference = new Reference(object, this, recorder);
        this._type = type;
        if (!this.isComplete()) {
            this._backlinkSet = new BacklinkSet();
        }
    }

    @Override
    public boolean isComplete() {
        return this._reference.isComplete();
    }

    @Override
    public boolean isBound() {
        return false;
    }

    public Class<?> getType() {
        return this._type;
    }

    private void checkBacklinkSet() {
        if (this._backlinkSet == null) {
            if (this.isComplete()) {
                throw new RuntimeException("A complete tuple received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete tuple lacks a backlink set. Strange");
        }
    }

    @Override
    public void addBacklink(Reference reference, StateRecorder recorder) {
        this._recorderChecker.checkRecorder(recorder);
        this.checkBacklinkSet();
        this._backlinkSet.addBacklink(reference, recorder);
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> listeners, StateRecorder recorder) throws Impossible {
        if (this.isComplete()) {
            this.checkBacklinkSet();
            this._backlinkSet.updateBacklinked(this, this, listeners, recorder);
            BacklinkSet oldBacklinkSet = this._backlinkSet;
            if (recorder != null) {
                recorder.record(() -> {
                    this._backlinkSet = oldBacklinkSet;
                });
            }
            this._backlinkSet = null;
        }
    }

    @Override
    public void occursCheck(Unknown that, Set<IdentityWrapper> visited) throws Impossible {
        if (this._reference.isComplete()) {
            return;
        }
        IdentityWrapper thisWrapper = new IdentityWrapper(this);
        if (visited.contains(thisWrapper)) {
            return;
        }
        visited.add(thisWrapper);
        this._reference.occursCheck(that, visited);
    }

    public boolean equals(Object that) {
        throw new RuntimeException("Somebody compared a calculator.");
    }

    public int hashCode() {
        throw new RuntimeException("Somebody took the hash code of a calculator.");
    }

    public String toString() {
        return "<pending: " + String.valueOf(this.getType()) + ">";
    }
}

