/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.ArityBranch;
import de.renew.unify.ComponentBranch;
import de.renew.unify.EstimateVisitor;
import de.renew.unify.TupleIndexVisitor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TupleIndex
implements Serializable {
    private final ArityBranch _tree = new ArityBranch();
    private final Set<Object> _elements = new HashSet<Object>();

    static Integer theHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public synchronized void insert(final Object elem) {
        this._elements.add(elem);
        this._tree.traverse(new TupleIndexVisitor(){

            @Override
            public void visitBranch(ComponentBranch branch) {
                branch.addElement(elem);
            }

            @Override
            public boolean visitIndex(ArityBranch branch, Object remainder) {
                branch.getHashCodeRelation().put((Object)TupleIndex.theHashCode(remainder), elem);
                return true;
            }
        }, elem);
    }

    public synchronized void remove(final Object elem) {
        this._elements.remove(elem);
        this._tree.traverse(new TupleIndexVisitor(){

            @Override
            public void visitBranch(ComponentBranch branch) {
                branch.removeElement(elem);
            }

            @Override
            public boolean visitIndex(ArityBranch branch, Object remainder) {
                branch.getHashCodeRelation().remove((Object)TupleIndex.theHashCode(remainder), elem);
                return true;
            }
        }, elem);
    }

    public Set<Object> getAllElements() {
        return this._elements;
    }

    public Set<Object> getPossibleMatches(Object pattern) {
        EstimateVisitor visitor = new EstimateVisitor();
        this._tree.traverse(visitor, pattern);
        visitor.possibleCollection(this.getAllElements());
        return visitor.getBestSet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(TupleIndex.class.getName());
        builder.append("(");
        Iterator<Object> enumeration = this.getAllElements().iterator();
        while (enumeration.hasNext()) {
            builder.append(enumeration.next());
            if (!enumeration.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

