/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawingLoadServer;
import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.application.DrawingViewContainerSupplier;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.Toolbar;
import CH.ifa.draw.framework.UndoRedoManager;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.AutosaveManager;
import CH.ifa.draw.util.AutosaveSaver;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.DrawingIOManager;
import CH.ifa.draw.util.DrawingListener;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteListener;
import de.renew.windowmanagement.RenewShutdownHook;
import de.renew.windowmanagement.Workbench;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DrawApplication
implements DrawingEditor,
PaletteListener,
StatusDisplayer,
AutosaveSaver {
    public static Logger logger = Logger.getLogger(DrawApplication.class);
    private static int windowCount = 0;
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int LAYOUT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    public static final int DRAWINGS_MENU = 4;
    private static final int AUTOSAVE_INTERVAL = 120000;
    private final StandardDrawingEditor fDelegateEditor;
    private final DrawingIOManager fIOManager;
    protected DrawingViewContainer fViewContainer;
    private AutosaveManager autosaveManager = new AutosaveManager(this, 120000L);
    private Vector<DrawingListener> drawingListeners;
    protected Workbench fWorkbench;
    private static Font fMenuFont;

    public DrawApplication(String title, String defaultDrawingType, SimpleFileFilter defaultFileFilter, String[] drawings, String icon, Workbench workbench, StandardDrawingEditor editor) {
        DrawPlugin.setGui(this);
        this.drawingListeners = new Vector();
        if (defaultFileFilter != null) {
            DrawingTypeManager dtm = DrawingTypeManager.getInstance();
            dtm.register(defaultDrawingType, defaultFileFilter);
            dtm.setDefaultFileFilter(defaultFileFilter);
        }
        DrawingLoadServer dls = null;
        int loadServerPort = GUIProperties.loadServerPort();
        if (loadServerPort != -1) {
            try {
                dls = new DrawingLoadServer(this, loadServerPort);
            }
            catch (IOException ioe) {
                logger.error((Object)"Server Socket is occupied!");
            }
        }
        this.fWorkbench = workbench;
        fMenuFont = workbench.getMainFrame().getFont();
        this.fDelegateEditor = editor;
        this.fIOManager = new DrawingIOManager(this.fDelegateEditor, this.fWorkbench);
        this.fWorkbench.registerShutdownHook((RenewShutdownHook)new DrawApplicationShutdownHook(this));
        Iconkit iconkit = new Iconkit(this.fWorkbench.getMainFrame());
        if (icon != null) {
            Image iconImage = iconkit.loadImage(icon);
            if (iconImage == null) {
                logger.error((Object)("Resource icon " + icon + " could not be loaded!"));
            } else {
                this.fWorkbench.getMainFrame().setIconImage(iconImage);
            }
        }
        this.loadAndOpenCommandLineDrawings(drawings);
        if (dls != null) {
            dls.start();
        }
        JMenuItem showMainWindowItem = new JMenuItem("Menu and tools");
        showMainWindowItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        showMainWindowItem.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                JFrame menuFrame = DrawApplication.this.getFrame();
                menuFrame.setExtendedState(menuFrame.getExtendedState() & 0xFFFFFFFE);
                menuFrame.toFront();
            }
        });
        MenuManager.getInstance().registerMenu("Windows", showMainWindowItem, "CH.ifa.drawWindowsMenu and tools");
        MenuManager.getInstance().setGui(this);
        logger.debug((Object)"DrawApplication: started gui.");
    }

    @Override
    public Image getIconImage() {
        return this.fDelegateEditor.getIconImage();
    }

    public JFrame getFrame() {
        return this.fWorkbench.getMainFrame();
    }

    @Override
    public void dispatchEvent(KeyEvent evt) {
        this.fDelegateEditor.dispatchEvent(evt);
    }

    public void setDrawingViewContainerSupplier(DrawingViewContainerSupplier newDVCSupplier) {
    }

    private void updateName(Drawing drawing, File filename) {
        this.fIOManager.updateName(drawing, filename);
    }

    void addMenu(JMenu newMenu, int index) {
        this.fDelegateEditor.addMenu(newMenu, index);
    }

    void addMenu(JMenu newMenu) {
        this.fDelegateEditor.addMenu(newMenu);
    }

    void removeMenu(JMenu remove) {
        this.fDelegateEditor.removeMenu(remove);
    }

    public void destroyViewContainer(DrawingViewContainer viewContainer) {
        this.fDelegateEditor.closeDrawing(viewContainer.view().drawing());
    }

    public static Font getMenuFont() {
        return fMenuFont;
    }

    public static JMenuItem createMenuItem(String name, int shortcut, ActionListener action) {
        JMenuItem mi;
        if (shortcut == 0) {
            mi = new JMenuItem(name);
        } else {
            mi = new JMenuItem(name, shortcut);
            mi.setAccelerator(KeyStroke.getKeyStroke(shortcut, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        mi.setFont(fMenuFont);
        mi.addActionListener(action);
        return mi;
    }

    public static JMenuItem createMenuItem(String name, ActionListener action) {
        return DrawApplication.createMenuItem(name, 0, action);
    }

    public static CommandMenu createCommandMenu(String name) {
        CommandMenu cm = new CommandMenu(name);
        cm.setFont(fMenuFont);
        return cm;
    }

    public Enumeration<Drawing> drawings() {
        return this.fDelegateEditor.getDrawingLookup().getAllDrawings();
    }

    public void addDrawingListener(DrawingListener listener) {
        this.fDelegateEditor.getDrawingLookup().addDrawingListener(listener);
    }

    public void removeDrawingListener(DrawingListener listener) {
        this.fDelegateEditor.getDrawingLookup().removeDrawingListener(listener);
    }

    @Override
    public void setCurrentDrawing(DrawingViewContainer viewContainer) {
    }

    public DrawingView getView(Drawing drawing) {
        return this.fDelegateEditor.getView(drawing);
    }

    public void showDrawingViewContainer(Drawing drawing) {
        this.fDelegateEditor.openDrawing(drawing);
    }

    public boolean closeDrawing(Drawing drawing) {
        this.fDelegateEditor.closeDrawing(drawing);
        return this.fIOManager.getClosingResult();
    }

    @Override
    public void paletteUserSelected(ToolButton button, boolean doubleclick) {
        this.fDelegateEditor.paletteUserSelected(button, doubleclick);
    }

    @Override
    public void paletteUserOver(ToolButton button, boolean inside) {
        this.fDelegateEditor.paletteUserOver(button, inside);
    }

    @Override
    public Drawing drawing() {
        return this.fDelegateEditor.drawing();
    }

    @Override
    public Tool tool() {
        return this.fDelegateEditor.tool();
    }

    @Override
    public Tool defaultTool() {
        return null;
    }

    @Override
    public DrawingView view() {
        return this.fDelegateEditor.view();
    }

    @Override
    public DrawingView previousView() {
        return this.fDelegateEditor.previousView();
    }

    public void toggleAlwaysSticky() {
    }

    @Override
    public boolean isStickyTools() {
        return this.fDelegateEditor.isStickyTools();
    }

    @Override
    public void setStickyTools(boolean sticky) {
        this.fDelegateEditor.setStickyTools(sticky);
    }

    @Override
    public void toolDone() {
        this.fDelegateEditor.toolDone();
    }

    @Override
    public void selectionChanged(DrawingView view) {
        this.fDelegateEditor.selectionChanged(view);
    }

    public void recheckMenus() {
        this.menuStateChanged();
    }

    @Override
    public void menuStateChanged() {
        this.fDelegateEditor.menuStateChanged();
    }

    @Override
    public void showStatus(String string) {
        this.fDelegateEditor.showStatus(string);
    }

    public ToolButton toolButtonForTextFigure(TextFigure figure) {
        return this.fDelegateEditor.toolButtonForTextFigure(figure);
    }

    public void doTextEdit(TextFigure textFigure, int line, int column) {
        this.fDelegateEditor.doTextEdit(textFigure, line, column, 0, 0);
    }

    public void doTextEditSelected(TextFigure textFigure, int startLine, int startColumn, int endLine, int endColumn) {
        this.fDelegateEditor.doTextEdit(textFigure, startLine, startColumn, endLine, endColumn);
    }

    @Override
    public void doTextEdit(TextFigure textFigure) {
        this.fDelegateEditor.doTextEdit(textFigure, 0, 0, 0, 0);
    }

    @Override
    public Toolbar getToolbar() {
        return this.fDelegateEditor.getToolbar();
    }

    public Drawing promptChooseNew() {
        return this.fIOManager.promptChooseNew();
    }

    public void promptOpen(FileFilter ff) {
        this.fIOManager.promptOpen(ff);
    }

    void promptOpenURL() {
        this.fIOManager.promptOpenURL();
    }

    protected void promptInsert() {
        this.fIOManager.promptInsert();
    }

    public void saveDrawingAs(Drawing drawing) {
        this.fIOManager.saveDrawingAs(drawing);
    }

    public boolean saveDrawing(Drawing drawing) {
        return this.fIOManager.saveDrawing(drawing);
    }

    @Override
    public void openOrLoadDrawing(File file) {
        this.fDelegateEditor.openOrLoadDrawing(file);
    }

    public void openOrLoadDrawing(String path) {
        this.openOrLoadDrawing(new File(path));
    }

    protected void saveDrawing(Drawing drawing, File filename) {
        this.fIOManager.saveDrawing(drawing, filename);
    }

    protected boolean promptSaveAs() {
        return this.promptSaveAs(this.drawing());
    }

    protected boolean promptSaveAs(Drawing drawing) {
        return this.fIOManager.promptSaveAs(drawing);
    }

    public void print() {
        this.fDelegateEditor.print();
    }

    @Override
    public void saveAutosaveFile(Drawing drawing, File file, Point loc, Dimension size) throws IOException {
    }

    public void loadAndOpenCommandLineDrawings(final String[] filenames) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < filenames.length; ++i) {
                    try {
                        DrawApplication.this.getIOHelper().loadAndOpenDrawings(new URL(filenames[i]));
                        continue;
                    }
                    catch (MalformedURLException e2) {
                        DrawApplication.this.openOrLoadDrawing(filenames[i]);
                    }
                }
            }
        });
    }

    public void loadAndOpenCommandLineDrawing(final URL url) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawApplication.this.getIOHelper().loadAndOpenDrawings(url);
            }
        });
    }

    public synchronized void openDrawing(PositionedDrawing posDrawing) {
        this.fDelegateEditor.openDrawing(posDrawing.getDrawing());
    }

    public Drawing openDrawing(Drawing drawing) {
        return this.fDelegateEditor.openDrawing(drawing);
    }

    protected synchronized void loadAndInsertDrawing(File file) {
        Drawing existingDrawing = this.drawing();
        DrawingView existingView = this.view();
        Drawing newDrawing = DrawingFileHelper.loadDrawing(file, null);
        if (newDrawing != null) {
            FigureEnumeration figures = newDrawing.figures();
            existingView.clearSelection();
            while (figures.hasMoreElements()) {
                Figure fig = figures.nextFigure();
                existingDrawing.add(fig);
                existingView.addToSelection(fig);
            }
            existingView.checkDamage();
        }
    }

    private IOHelper getIOHelper() {
        return DrawPlugin.getCurrent().getIOHelper();
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return this.fDelegateEditor.getUndoRedoManager();
    }

    @Override
    public void drawingViewContainerActivated(DrawingViewContainer viewContainer) {
    }

    @Override
    public void drawingViewContainerClosing(DrawingViewContainer viewContainer) {
    }

    @Override
    public void prepareUndoSnapshot() {
        this.fDelegateEditor.prepareUndoSnapshot();
    }

    @Override
    public void commitUndoSnapshot() {
        this.fDelegateEditor.commitUndoSnapshot();
    }

    @Override
    public void prepareAccumulatedUndoSnapshot() {
        this.fDelegateEditor.prepareAccumulatedUndoSnapshot();
    }

    @Override
    public void triggerAccumulatedUndoSnapshot() {
        this.fDelegateEditor.triggerAccumulatedUndoSnapshot();
    }

    public boolean selectOffendingElements(FigureException e) {
        if (e.errorDrawing != null && !e.errorFigures.isEmpty()) {
            this.view().clearSelection();
            this.showDrawingViewContainer(e.errorDrawing);
            FigureEnumerator errorFigures = new FigureEnumerator(e.errorFigures);
            this.view().addToSelectionAll(errorFigures);
            this.view().repairDamage();
            if (e.textErrorFigure != null) {
                this.view().showElement(e.textErrorFigure);
                this.doTextEdit(e.textErrorFigure, e.line, e.column);
            }
            return true;
        }
        return false;
    }

    public void closeAllDrawings() {
        this.fDelegateEditor.getDrawingLookup().closeAllDrawings();
    }

    public void closeCurrentDrawing() {
        this.fDelegateEditor.closeCurrentDrawing();
    }

    public void promptNew() {
        this.fDelegateEditor.newDrawing();
    }

    protected void requestClose() {
        if (this.canClose()) {
            this.exit();
        }
    }

    public boolean canClose() {
        boolean result = true;
        Enumeration<Drawing> drawings = this.fDelegateEditor.getDrawingLookup().getAllDrawings();
        while (result && drawings.hasMoreElements()) {
            Drawing drawing = drawings.nextElement();
            if (!drawing.isModified()) continue;
            result = this.fIOManager.handleModifiedDrawing(drawing);
        }
        return result;
    }

    public boolean canOpen(URI path) {
        ImportFormat[] allImportFormats;
        for (SimpleFileFilter filter : this.getIOHelper().getFileFilter().getFileFilters()) {
            if (!filter.accept(new File(path.getPath()))) continue;
            return true;
        }
        for (ImportFormat importFormat : allImportFormats = this.getImportHolder().allImportFormats()) {
            if (!importFormat.canImport(path)) continue;
            return true;
        }
        return false;
    }

    private ImportHolder getImportHolder() {
        return DrawPlugin.getCurrent().getImportHolder();
    }

    public void exit() {
    }

    @Override
    public void registerDrawingViewFactoryID(Class key, String id) {
        this.fDelegateEditor.registerDrawingViewFactoryID(key, id);
    }

    private class DrawApplicationShutdownHook
    implements RenewShutdownHook {
        DrawApplication application;

        DrawApplicationShutdownHook(DrawApplication app) {
            this.application = app;
        }

        public boolean canClose() {
            return this.application.canClose();
        }

        public void exit() {
            this.application.exit();
        }
    }
}

