/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class ChopPieConnector
extends ChopBoxConnector {
    public static final Logger logger = Logger.getLogger(ChopPieConnector.class);
    private PieFigure pieFig;

    public ChopPieConnector() {
    }

    public ChopPieConnector(PieFigure owner) {
        super(owner);
        this.pieFig = owner;
    }

    @Override
    protected Point chop(Figure target, Rectangle source) {
        Rectangle r = target.displayBox();
        Point from = Geom.center(source);
        double angle_rad = Geom.pointToAngle(r, from) + (r.intersection(source).equals(r) ? Math.PI : 0.0);
        if (this.pieFig != null) {
            double angle_deg;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Chopping for pieFig=" + String.valueOf(this.pieFig) + ", given target=" + String.valueOf(target) + ", given source=" + String.valueOf(source) + "."));
            }
            double chosenAngle = angle_deg = PieFigure.normalizeAngle(-Math.toDegrees(angle_rad));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("   Angles are: angle_rad=" + angle_rad + ", angle_deg=" + angle_deg + ", pieFig.getStartAngle()=" + this.pieFig.getStartAngle() + ", pieFig.getEndAngle()=" + this.pieFig.getEndAngle() + "."));
            }
            if (this.pieFig.getStartAngle() < this.pieFig.getEndAngle()) {
                logger.debug((Object)"   start < end");
                if (angle_deg < this.pieFig.getStartAngle()) {
                    logger.debug((Object)"   angle < start < end");
                    chosenAngle = this.pieFig.getStartAngle() - angle_deg < angle_deg + 360.0 - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
                } else if (this.pieFig.getEndAngle() < angle_deg) {
                    logger.debug((Object)"   start < end < angle");
                    chosenAngle = this.pieFig.getStartAngle() + 360.0 - angle_deg < angle_deg - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
                }
            } else if (this.pieFig.getStartAngle() > this.pieFig.getEndAngle() && this.pieFig.getStartAngle() > angle_deg && angle_deg > this.pieFig.getEndAngle()) {
                logger.debug((Object)"   end < angle < start");
                chosenAngle = this.pieFig.getStartAngle() - angle_deg < angle_deg - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
            }
            if (chosenAngle != angle_deg) {
                angle_rad = -Math.toRadians(chosenAngle);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("   chosen angle is: deg=" + chosenAngle + ", rad=" + angle_rad + "."));
                }
            } else {
                logger.debug((Object)"   chosen angle is unchanged.");
            }
        }
        return Geom.ovalAngleToPoint(r, angle_rad);
    }
}

