/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.util.Vector;

public class UngroupCommand
extends UndoableCommand {
    public UngroupCommand(String name) {
        super(name);
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        FigureEnumeration selection = view.selectionElements();
        view.clearSelection();
        Vector<Figure> parts = new Vector<Figure>();
        while (selection.hasMoreElements()) {
            Figure selected = selection.nextFigure();
            Figure group = view.drawing().orphan(selected);
            FigureEnumeration k = group.decompose();
            while (k.hasMoreElements()) {
                parts.addElement(k.nextFigure());
            }
        }
        view.addAll(parts);
        view.addToSelectionAll(parts);
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

