/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;

public abstract class UndoableCommand
extends Command {
    public UndoableCommand(String name) {
        super(name);
    }

    @Override
    public void execute() {
        DrawingEditor editor = this.getEditor();
        editor.prepareUndoSnapshot();
        boolean changed = this.executeUndoable();
        if (changed) {
            editor.commitUndoSnapshot();
        }
    }

    protected DrawingEditor getEditor() {
        DrawPlugin plugin = DrawPlugin.getCurrent();
        return plugin == null ? NullDrawingEditor.INSTANCE : plugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor() != NullDrawingEditor.INSTANCE;
    }

    protected abstract boolean executeUndoable();
}

